<?PHP

/**
 * Class used to add additional functionality to the Folder class.
 */
class Folders_Folder extends Folder
{

    /**
     * Get the item IDs, optionally specifying a subset of them.
     * @param int $Offset index of the item to begin the subset
     * @param int $Length maximum length of the subset
     * @return array the item IDs or a subset if offset given
     */
    public function GetItemIds($Offset=NULL, $Length=NULL)
    {
        if (!is_null($Offset))
        {
            return array_slice(parent::GetItemIds(), $Offset, $Length);
        }

        return parent::GetItemIds();
    }

    /**
     * Get the number of items in the folder
     * @return int the number of items in the folder
     */
    public function GetItemCount()
    {
        return count($this->GetItemIds());
    }

}
