<?PHP

/**
* Peform any follow-up tasks after a new installation.  Tasks that go here are
*   typically those that can be performed after the site is in use.
*/
function PerformNewInstallFollowUp()
{
    # load default search synonym list
    $SearchEngine = new SPTSearchEngine();
    $SearchEngine->LoadSynonymsFromFile(
            "lib/ScoutLib/SearchEngine--DefaultSynonymList.txt");

    # queue complete search DB rebuild
    $RFactory = new ResourceFactory();
    $Ids = $RFactory->GetItemIds();
    foreach ($Ids as $Id)
    {
        $SearchEngine->QueueUpdateForItem($Id,
                ApplicationFramework::PRIORITY_BACKGROUND);
    }

    # queue complete recommender DB rebuild
    $Recommender = new SPTRecommender();
    foreach ($Ids as $Id)
    {
        $Recommender->QueueUpdateForItem((int)$Id,
                ApplicationFramework::PRIORITY_BACKGROUND);
    }
    $GLOBALS["AF"]->QueueUniqueTask(array($Recommender, "PruneCorrelations"),
                array(), ApplicationFramework::PRIORITY_BACKGROUND);

    $ResourceFactory = new ResourceFactory();
    $ResourceFactory->UpdateResourceCountCallback();
}

?>
