-- new column used for specifying which line ending should be used in e-mail message bodies
ALTER TABLE SystemConfiguration ADD EmailLineEnding ENUM('CRLF','CR','LF') NOT NULL DEFAULT 'CRLF';

-- update the description for the Audience field if it hasn't changed since CWIS was installed
UPDATE MetadataFields
SET Description = 'A category of user for whom the resource is intended. Frequently, creators and publishers of resources in education explicitly state the category of user for whom the resource is intended. In like fashion, end-users in the education/training domain frequently search using audience characteristics as search terms. The default values are drawn from the broadest educational category levels. The software allows for multiple values to be selected from this field. This field is used by the Advanced Search Engine as a Limiter. The portal software allows for modifications and edits to these default values through the Edit Option Lists feature on the Metadata Tool navigation bar. This feature will not be visible to anyone without adequate permission.'
WHERE FieldName = 'Audience'
AND Description = 'A category of user for whom the resource is intended. Frequently, creators and publishers of resources in education explicitly state the category of user for whom the resource is intended. In like fashion, end-users in the education/training domain frequently search using audience characteristics as search terms. The default values are drawn from the broadest educational category levels. The software allows for multiple values to be selected from this field. This field is used by the Advanced Search Engine as a Limiter. The portal software allows for modifications and edits to these default values through the Edit Option Lists feature on the Metadata Tool navigation bar. This feature will not be visible to anyone without adequate permission. DC-Education Working Group prosposed element.';

-- update the instructions for the Classification field if it hasn't changed since CWIS was installed
UPDATE MetadataFields
SET Instructions = 'Broadest tier - More specific - Most specific (ex. Science - Physics - Atomic structure)'
WHERE FieldName = 'Classification'
AND Instructions IS NULL;

-- update the instructions for the Date Issued field if it hasn't changed since CWIS was installed
UPDATE MetadataFields
SET Instructions = 'YYYY: Four digit year of publication.\r\nYYYY-MM: Four digit year with a two digit month.\r\nYYYY-MM-DD: Four digit year with two digit month and two digit day.\r\n[YYYY]: Year of publication, but date inferred from outside the resource being described.\r\nYYYY-\r\nPublication is continuous as with an e-journal, magazine, or serial.\r\n[YYYY]- : Source for the assigned date not directly from the resources itself. Publication is continuous as with an e-journal, magazine, or serial.\r\nYYYY-YYYY: Published between a set of years.\r\ncYYYY: The copyright date.\r\nYYYY,YYYY: Publication originally published in the first date and then subsequently republished in another format at the second date.'
WHERE FieldName = 'Date Issued'
AND Instructions IS NULL;

-- update the description for the Source field if it hasn't changed since CWIS was installed
UPDATE MetadataFields
SET Description = 'A reference to a resource from which the present resource is derived. The present resource may be derived from the Source resource in whole or in part. Dublin Core Metadata Initiative recommended best practice is to reference the resource by means of a string or number conforming to a formal identification system. DCMI element.'
WHERE FieldName = 'Source'
AND Description = 'A Reference to a resource from which the present resource is derived. The present resource may be derived from the Source resource in whole or in part. Dublin Core Metadata Initiative recommended best practice is to reference the resource by means of a string or number conforming to a formal identification system. DCMI element.';
