<?PHP
#
#   FILE:  Preferences.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintSuccessMessages()
{
    global $SuccessMessages;

    # if messages were passed from PreferencesComplete
    if (is_array($SuccessMessages))
    {
        foreach ($SuccessMessages as $Message)
        {
            PrintSuccessMessage($Message);
        }
    }
}

function PrintErrorMessages()
{
    global $ErrorMessages;
    global $SuccessMessages;

    # if error messages were passed from PreferencesComplete
    if (is_array($ErrorMessages))
    {
        if (function_exists("PrintErrorMessage"))
        {
            foreach ($ErrorMessages as $Message)
            {
                PrintErrorMessage($Message);
            }
        }

        # backwards compatibility
        else
        {
            $AllMessages = (is_array($SuccessMessages))
                ? array_merge($ErrorMessages, $SuccessMessages) : $ErrorMessages;

            # print error messages
            print("<ul>\n");

            foreach ($AllMessages as $Message)
            {
                printf("<li>%s</li>\n", $Message);
            }

            print("</ul>\n");
        }
    }
}

function PrintActiveUIOptionList()
{
    # the user has an active UI set
    if ($GLOBALS["G_User"]->Get("ActiveUI"))
    {
        $ActiveUI = $GLOBALS["G_User"]->Get("ActiveUI");
    }

    # otherwise use the system default
    else
    {
        $ActiveUI = $GLOBALS["G_SysConfig"]->DefaultActiveUI();
    }

    # print option list for UI
    print GetActiveUIOptionList($ActiveUI);
}

function PrintSearchResultsPerPageOptionList()
{
    global $User, $SysConfig;

    $Selected = NULL;

    if ($User->IsLoggedIn())
    {
        $Selected = $User->Get("RecordsPerPage");
    }

    if (is_null($Selected))
    {
        $Selected = $SysConfig->DefaultRecordsPerPage();
    }

    foreach (array(5, 10, 20, 30, 50, 100) as $Option)
    {
        print "<option";

        if ($Option == $Selected)
        {
            print " selected=\"selected\"";
        }

        print ">".$Option."</option>";
    }
}

function PrintCurrentRealName()
{
    global $User;
    print($User->Get("RealName"));
}

function PrintCurrentEMail()
{
    global $User;
    print($User->Get("EMail"));
}

function PrintCurrentWebSite()
{
    global $User;
    print($User->Get("WebSite"));
}

function PrintCurrentAddressLineOne()
{
    global $User;
    print($User->Get("AddressLineOne"));
}

function PrintCurrentAddressLineTwo()
{
    global $User;
    print($User->Get("AddressLineTwo"));
}

function PrintCurrentCity()
{
    global $User;
    print($User->Get("City"));
}

function PrintCurrentState()
{
    global $User;
    print($User->Get("State"));
}

function PrintCurrentZipCode()
{
    global $User;
    print($User->Get("ZipCode"));
}

function PrintCurrentCountry()
{
    global $User;
    print($User->Get("Country"));
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $SuccessMessages;
global $H_ReturnTo;

$H_ReturnTo = GetArrayValue($_POST, "F_ReturnTo", GetArrayValue($_GET, "ReturnTo", GetArrayValue($_SERVER, "HTTP_REFERER")));

PageTitle("User Preferences");

# make sure the user is authorized to view the page
if (!$User->IsLoggedIn())
{
    CheckAuthorization(FALSE);
    return;
}

# get error messages saved in the session
if ($Session->IsRegistered("ErrorMessages"))
{
    $ErrorMessages = $Session->Get("ErrorMessages");
}

if ($Session->IsRegistered("SuccessMessages"))
{
    $SuccessMessages = $Session->Get("SuccessMessages");
}

# update timestamps as required
$Schema = new MetadataSchema(MetadataSchema::SCHEMAID_USER);
$TimestampFields = $Schema->GetFields(MetadataSchema::MDFTYPE_TIMESTAMP);
$Resource = $GLOBALS["G_User"]->GetResource();
foreach ($TimestampFields as $Field)
{
    if ($Field->UpdateMethod() ==
        MetadataField::UPDATEMETHOD_ONRECORDEDIT)
    {
        $Resource->Set($Field->Name(), "now");
    }
}
