<?PHP
#
#   FILE:  TestRecommender.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2002-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Recommender System Test");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

print("<h1>Recommender System Test</h1>\n");

$Rec = new SPTRecommender();
$Rec->DebugLevel(0);
#$FieldList = array("Title", "Description", "Url", "Alternate Title");
$FieldList = array("Title", "Description");

print("Fields Used to Generate Recommendations:<br>\n");
foreach ($FieldList as $FieldName)
{
    print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>".$FieldName."</i><br>\n");
}
print("<br>\n");

$DB->Query("SELECT ResourceId FROM Resources WHERE ResourceId > 0 AND ResourceId < 13000 ORDER BY ResourceId");
$ItemIds = $DB->FetchColumn("ResourceId");

$ItemsToProcess = 750;
$ItemsProcessed = 0;
ob_start();
foreach ($ItemIds as $ItemId)
{
    $Vals = $Rec->RecommendFieldValues($ItemId, $FieldList);
    if (is_array($Vals["Classification"]) && (count($Vals["Classification"]) > 0))
    {
        print("<br>\n");
        print("Resource ID:  <a href=\"index.php?P=FullRecord"
              ."&amp;ResourceId=".$ItemId."\">".$ItemId."</a><br>\n");
        $Resource = new Resource($ItemId);
        print("Title: ".$Resource->GetMapped("Title")."<br>\n");
        $Classes = $Resource->Get("Classification");
        print("Assigned Classifications (".count($Classes)." values):<br>\n");
        foreach ($Classes as $Val)
        {
            print("&nbsp;&nbsp;&nbsp;&nbsp;$Val<br>\n");
        }
        print("Recommended Classifications (".count($Vals["Classification"])." values):<br>\n");
        $MatchCount = 0;
        foreach ($Vals["Classification"] as $Val => $Count)
        {
            print("&nbsp;&nbsp;&nbsp;&nbsp;$Val<br>\n");
            foreach ($Classes as $ClassVal)
            {
                if (($Val == $ClassVal)
                    || (strncmp($Val, $ClassVal, (strlen($Val) < strlen($ClassVal) ? strlen($Val) : strlen($ClassVal))) == 0))
                {
                    $MatchCount++;
                }
            }
        }
        if ($MatchCount > 0) {  print("<b>");  }
        print("Matching Classifications: ".$MatchCount."<br>\n");
        if ($MatchCount > 0) {  print("</b>");  }
        $TotalClassCount += count($Classes);
        $TotalRecommendCount += count($Vals["Classification"]);
        $ResourceRecommendCount++;
        $TotalMatchCount += $MatchCount;
        print("<br>\n");
    }

    $ItemsProcessed++;
    if ($ItemsProcessed == $ItemsToProcess) {  break;  }
}
$Details = ob_get_contents();
ob_end_clean();

print("Total Resources Processed: ".$ItemsToProcess."<br>\n");
print("Total Resources w/ Recommendations: ".$ResourceRecommendCount."<br>\n");
printf("Recommendation Rate: <b>%d%%</b><br>\n", intval(($ResourceRecommendCount * 100) / $ItemsToProcess));
print("<br>\n");
print("Total Classes Assigned: ".$TotalClassCount."<br>\n");
print("Total Classes Recommended: ".$TotalRecommendCount."<br>\n");
printf("Recommendation Match Rate: <b>%0.2f%%</b><br>\n", (($TotalMatchCount * 100) / $TotalRecommendCount));
print("<br>\n");
print("<br>\n");
print("<hr><br>\n");

print($Details);


include(FindUIFile("include/SPT--StandardPageEnd.html"));

?>
