<?PHP
#
#   FILE:  UpdateResourceNote.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

# check authorization and setup HTML suppression and page redirection
if (!Folders_Common::ApiPageCompletion("P_Folders_ManageFolders")) return;

# canceled editing
if (GetArrayValue($_GET, "Cancel"))
{
    return;
}

$FolderId = GetArrayValue($_GET, "FolderId");
$ItemId = GetArrayValue($_GET, "ItemId");
$ResourceNote = GetArrayValue($_GET, "ResourceNote");

# can't do anything if there aren't IDs to work with
if (!strlen($FolderId) || !strlen($ItemId))
{
    return;
}

try
{
    $FolderFactory = new Folders_FolderFactory($User->Id());
    $ResourceFolder = $FolderFactory->GetResourceFolder();
    $Folder = new Folders_Folder($FolderId);

    # withdraw only if the resource folder contains this folder, which implies
    # that the user owns the folder and it's a valid folder of resources
    if ($ResourceFolder->ContainsItem($Folder->Id()))
    {
        $Resource = new Resource($ItemId);

        # make sure the resource is valid and the folder contains it
        if ($Resource->Status() === 1 && $Folder->ContainsItem($Resource->Id()))
        {
            $Folder->NoteForItem($Resource->Id(), $ResourceNote);
        }
    }
} catch (Exception $Exception) {}
