<?PHP
#
#   FILE:  GetKML.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

$AF->SuppressHTMLOutput();

header('Content-type: application/vnd.google-earth.kml+xml');

$PointProvider = GetArrayValue($_GET, "PP");
$DetailProvider = GetArrayValue($_GET, "DP");

# only continue if given the parameters
if ($PointProvider && $DetailProvider)
{
    $Path = $AF->SignalEvent(
        "GoogleMaps_EVENT_GET_KML",
        array($PointProvider, $DetailProvider));

    if (file_exists($Path))
    {
        # send the file but unbuffered to avoid memory issues
        $AF->AddUnbufferedCallback("readfile", array($Path));
    }
}
