<?PHP
#
#   FILE:  Plugins.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("CWIS Plugins");

# check that the user has sufficient privileges
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

# if form was submitted
if (isset($_POST["SUBMITTED"]))
{
    # for each plugin
    $Attribs = $GLOBALS["G_PluginManager"]->GetPluginAttributes();
    foreach ($Attribs as $PluginName => $Attrib)
    {
        # updated enable/disable setting to reflect form checkboxes
        $GLOBALS["G_PluginManager"]->PluginEnabled($PluginName,
                (($PluginName == "CWISCore")
                || isset($_POST["EnabledCheckbox-".$PluginName]))
                ? TRUE : FALSE);
    }

    # save any resulting status messages before page is reloaded
    $_SESSION["PluginManagerStatusMessages"] =
            $GLOBALS["G_PluginManager"]->GetStatusMessages();

    # reload page so that correct set of plugins are loaded
    $GLOBALS["AF"]->SetJumpToPage("Plugins");
}
else
{
    # load any status or error messages
    global $H_ErrMsgs;
    global $H_StatusMsgs;
    $H_ErrMsgs = $GLOBALS["G_PluginManager"]->GetErrorMessages();
    if (array_key_exists("PluginManagerStatusMessages", $_SESSION))
    {
        $H_StatusMsgs = $_SESSION["PluginManagerStatusMessages"];
        unset($_SESSION["PluginManagerStatusMessages"]);
    }
    else
    {
        $H_StatusMsgs = $GLOBALS["G_PluginManager"]->GetStatusMessages();
    }
}

