<?PHP
#
#   FILE:  ConfirmDeleteComplete.php (RSSExport plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/cwis
#

# ----- MAIN -----------------------------------------------------------------

global $AF, $G_PluginManager;

# leave if the user is not a system administrator
if (!CheckAuthorization( PRIV_SYSADMIN )) { return; }

# rename form variables
$FeedId = intval(GetArrayValue($_POST, "F_ID", -1));
$OkayToDelete = intval(GetArrayValue($_POST, "F_OkayToDelete", -1));
$Submit = GetArrayValue($_POST, "F_Submit");

# go to Unauthorized if the necessary parameters were not passed
if ($FeedId === -1 || $OkayToDelete === -1 || $Submit == NULL)
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

# get a copy of the RSSExport plugin
$Plugin = $G_PluginManager->GetPlugin("RSSExport");

# get the available feeds
$Feeds = $Plugin->GetFeeds();

# go to Unauthorized if the feed does not exist
if (!array_key_exists($FeedId, $Feeds))
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

# if we are cancelling, go to the list feeds page
if ($Submit === "Cancel")
{
    $AF->SetJumpToPage("P_RSSExport_ListFeeds");
    return;
}

# get the desired feed
$Feed = $Feeds[$FeedId];

# delete the feed if it is okay to do so
if ($OkayToDelete && $Submit === "Delete RSS Feed")
{
    $Feed->Delete();
}

# go back to the list of RSS feeds
$AF->SetJumpToPage("P_RSSExport_ListFeeds");
