<?PHP
#
#   FILE:  RemoveItem.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

global $AF;

# check authorization and setup HTML suppression and page redirection
if (!Folders_Common::ApiPageCompletion("P_Folders_ManageFolders")) return;

$FolderId = GetArrayValue($_GET, "FolderId");
$ItemId = GetArrayValue($_GET, "ItemId");

# get the currently selected folder if no folder ID is given
if ($FolderId === NULL)
{
    $FolderFactory = new Folders_FolderFactory($User->Id());
    $FolderId = $FolderFactory->GetSelectedFolder()->Id();
}

# if "ReturnTo" is set, then jump back to that address
if (GetArrayValue($_GET, "ReturnTo", FALSE))
{
    $AF->SetJumpToPage(urldecode($_GET["ReturnTo"]));
}
# else jump back to the page which this page is being directed from
else if (isset($_SERVER["HTTP_REFERER"]))
{
    $AF->SetJumpToPage($_SERVER["HTTP_REFERER"]);
}
# jump to ViewFolder page if nothing is set
else
{
    $AF->SetJumpToPage($GLOBALS["AF"]->
        GetCleanUrlForPath("index.php?P=P_Folders_ViewFolder&FolderId=".$FolderId));
}

# can't do anything without an item ID
if (!strlen($ItemId))
{
    return;
}

try
{
    $FolderFactory = new Folders_FolderFactory($User->Id());
    $ResourceFolder = $FolderFactory->GetResourceFolder();
    $Folder = new Folders_Folder($FolderId);

    # remove the item only if the resource folder contains this folder, which
    # implies that the user owns the folder and it's a valid folder of resources
    if ($ResourceFolder->ContainsItem($Folder->Id()))
    {
        $Folder->RemoveItem($ItemId);
    }
} catch (Exception $Exception) {}
