<?PHP
#
#   FILE:  StartUp.php
#
#   USAGE:  This file initializes the CWIS operating environment, and may be
#       included in non-CWIS files that use the CWIS user login mechanism or
#       other portions of the CWIS application framework.
#
#   OPTIONS
#   These global variables may be set before including the file:
#       StartUpOpt_DO_NOT_LOAD_PLUGINS - When set to TRUE, plugins will not
#           be loaded at all.  (Though PluginManager will still be created.)
#       StartUpOpt_FORCE_PLUGIN_CONFIG_LOAD - When set to TRUE, all plugins will
#           be instructed to set up their configuration options, even if the
#           plugin is not currently enabled.
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/cwis
#

# save our current directory then change to CWIS base directory
$StartingDir = getcwd();
chdir(dirname(__FILE__)."/..");

# turn error reporting up to max if running local or at Scout
if (($_SERVER["HTTP_HOST"] == "localhost")
        || ($_SERVER["HTTP_HOST"] == "test.scout.wisc.edu"))
{
    error_reporting(E_ALL|E_STRICT);
    # (set time zone to prevent PHP local time zone warning from E_STRICT)
    date_default_timezone_set("America/Chicago");
}

# if configuration file available in expected location
if (file_exists("local/config.php"))
{
    # load configuration file
    require_once("local/config.php");
}
else
{
    # load configuration file from legacy location
    require_once("config.php");

}

# set configuration from legacy variables if necessary
if (!isset($GLOBALS["G_Config"]))
{
    $GLOBALS["G_Config"]["Database"] = array(
            "UserName" => $GLOBALS["SPT_DBUserName"],
            "Password" => $GLOBALS["SPT_DBPassword"],
            "Host" => $GLOBALS["SPT_DBHost"],
            "DatabaseName" => $GLOBALS["SPT_DBName"],
            );
    $GLOBALS["G_Config"]["UserInterface"] = array(
            "DefaultUI" => $GLOBALS["SPT_DefaultUI"],
            );
}

# set up database access
require_once("lib/AxisPHP/Axis--Database.php");
Database::SetGlobalServerInfo($GLOBALS["G_Config"]["Database"]["UserName"],
        $GLOBALS["G_Config"]["Database"]["Password"],
        $GLOBALS["G_Config"]["Database"]["Host"]);
Database::SetGlobalDatabaseName($GLOBALS["G_Config"]["Database"]["DatabaseName"]);

# turn on database error display if PHP error display is enabled
if (get_cfg_var("display_errors"))
{
    Database::DisplayQueryErrors(TRUE);
}

# set default storage engine for database server to MyISAM so any
#       new tables support full text searching
$DB = new Database();
$DB->SetDefaultStorageEngine("MyISAM");

# increase session data timeout to eight hours
require_once("lib/ScoutLib/ApplicationFramework.php");
ApplicationFramework::SessionLifetime(8 * 60 * 60);

# initialize application framework
ApplicationFramework::AddObjectDirectory("lib/ScoutLib");
ApplicationFramework::AddObjectDirectory("lib/AxisPHP", "Axis--");
ApplicationFramework::AddObjectDirectory("lib/PHPMailer", "class.");
$IncludeDirectories = array(
        "lib/CKEditor",
        "lib/D3",
        "lib/jsbn",
        );
$GLOBALS["AF"] = new ApplicationFramework();
$GLOBALS["AF"]->LogFile("local/logs/cwis.log");
require_once("include/Events.php");
$GLOBALS["AF"]->AddEnvInclude("include/Compat.php");
$GLOBALS["AF"]->AddIncludeDirectories($IncludeDirectories, TRUE);
$GLOBALS["AF"]->DoNotUrlFingerprint("%lib/CKEditor%");

# set up environment
require_once("include/Compat.php");
require_once("include/StdLib.php");
require_once("include/EnvSetup.php");
$GLOBALS["AF"]->HtmlCharset($GLOBALS["G_SysConfig"]->DefaultCharacterSet());
SearchParameterSet::SetCanonicalFieldFunction(
        array("MetadataSchema", "GetCanonicalFieldIdentifier"));
SearchParameterSet::SetPrintableFieldFunction(
        array("MetadataSchema", "GetPrintableFieldName"));

# load plugins
$PluginDirs = array(
        "plugins",
        "local/plugins",
        );
$GLOBALS["G_PluginManager"] = new PluginManager($GLOBALS["AF"], $PluginDirs,
        (array_key_exists("StartUpOpt_FORCE_PLUGIN_CONFIG_LOAD", $GLOBALS)
                && $GLOBALS["StartUpOpt_FORCE_PLUGIN_CONFIG_LOAD"]));
if (!array_key_exists("StartUpOpt_DO_NOT_LOAD_PLUGINS", $GLOBALS)
        || !$GLOBALS["StartUpOpt_DO_NOT_LOAD_PLUGINS"])
{
    $GLOBALS["G_PluginManager"]->LoadPlugins();
}

# set ownership of metadata fields by plugins
MetadataSchema::SetOwnerListRetrievalFunction(
        array($GLOBALS["G_PluginManager"], "GetActivePluginList"));
MetadataSchema::NormalizeOwnedFields();

# return to original directory
chdir($StartingDir);
