<?PHP
#
#   FILE:  Home.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2003-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Home");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function AnnouncementsEnabled()
{
    global $SysConfig;

    return $SysConfig->AnnouncementsEnabled();
}

function PrintPrevResourceLink()
{
    global $SysConfig;
    global $ResourceOffset;

    $NumResources = $SysConfig->NumResourcesOnHomePage();
    $Offset = $ResourceOffset + $NumResources;

    print "index.php?P=Home&amp;ResourceOffset=".$Offset;
}

function PrintNextResourceLink()
{
    global $SysConfig;
    global $ResourceOffset;

    $NumResources = $SysConfig->NumResourcesOnHomePage();
    $Offset = $ResourceOffset - $NumResources;

    print "index.php?P=Home&amp;ResourceOffset=".$Offset;
}

function NextResourcesAvailable()
{
    global $SysConfig;
    global $ResourceOffset;

    $NumResources = $SysConfig->NumResourcesOnHomePage();
    return ($ResourceOffset >= $NumResources) ? TRUE : FALSE;
}

function PreviousResourcesAvailable()
{
    global $MoreResources;
    return $MoreResources;
}

function PrintNumberOfResources()
{
    global $SysConfig;
    print $SysConfig->NumResourcesOnHomePage();
}

function PrintNewResourceTableRows()
{
    global $User;
    global $DB;
    global $MoreResources;
    global $SysConfig;
    global $ResourceOffset;

    $MaxDescriptionLength = 250;
    $MaxUrlLength = 60;

    if (is_null($ResourceOffset))
        $ResourceOffset = 0;

    # default values
    $MaxNumberOfResourcesToDisplay = $SysConfig->NumResourcesOnHomePage();
    $MaxNumberOfDaysToGoBackForResources = 7300;

    # if function to supply new resources is available
    if (function_exists("Local_GetNewResources"))
    {
        # call function to supply new resources
        $Resources = Local_GetNewResources(
                ($MaxNumberOfResourcesToDisplay + 1),
                $ResourceOffset,
                $MaxNumberOfDaysToGoBackForResources);
    }
    # backward compatibility to look for query string in UI file
    else if (function_exists("SupplyResourceDisplayQuery"))
    {
                # obtain query from function
        $DisplayQuery = SupplyResourceDisplayQuery(
                $MaxNumberOfDaysToGoBackForResources,
                $MaxNumberOfResourcesToDisplay+1,
                $ResourceOffset);

        # query database for appropriate resources
        $ResourceDB = new Database();
        $ResourceDB->Query($DisplayQuery);
        # set resource count
        $ResourceCount = $ResourceDB->NumRowsSelected();
        # get resources
        $Resources = array();
        while ($Resource = $ResourceDB->FetchRow())
        {
            array_push($Resources, new Resource($Resource["ResourceId"]));
        }
    }
    else
    {
        # retrieve resources using factory
        # NOTE:  Retrieves one more resource than is needed because we need
        #       to know if there are more resources.)
        $ResourceFact = new ResourceFactory();
        $Resources = $ResourceFact->GetRecentlyReleasedResources(
                ($MaxNumberOfResourcesToDisplay + 1),
                $ResourceOffset, $MaxNumberOfDaysToGoBackForResources);
    }

    # determine whether "Previous" link should be displayed
    $ResourceCount = count($Resources);
    $MoreResources = ($ResourceCount <= $MaxNumberOfResourcesToDisplay) ? FALSE : TRUE;

    # if resources found
    if ($ResourceCount)
    {
        # drop last resource if we have one more than is needed
        if ($ResourceCount > $MaxNumberOfResourcesToDisplay) {  array_pop($Resources);  }

        # for each resource
        foreach ($Resources as $Resource)
        {
            # display resource
            PrintNewResourceRow($Resource,
                    "index.php?P=FullRecord&amp;ID=".$Resource->Id(),
                    $Resource->UserCanEdit($User),
                    "index.php?P=EditResource&amp;ID=".$Resource->Id(),
                    $Resource->ScaledCumulativeRating());
        }
    }
    else
    {
        # print row with "no resources" notice
        PrintNoResourcesMessage();
    }
}

# (automatically called while outputing <head> section if defined)
function AddJavascript()
{
    # do nothing
}


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $AnnouncementOffset;
global $MoreAnnouncements;
global $MoreResources;
global $ResourceOffset;
global $ReleaseResourceTotal;

# get the total number of released resources
$ResourceFactory = new ResourceFactory();
$ReleaseResourceTotal = $ResourceFactory->GetReleasedResourceTotal();

if (isset($_GET["ResourceOffset"]))
    $ResourceOffset = intval($_GET["ResourceOffset"]);
else
    $ResourceOffset = 0;

if (isset($_GET["AnnouncementOffset"]))
    $AnnouncementOffset = intval($_GET["AnnouncementOffset"]);
else
    $AnnouncementOffset = 0;
