<?PHP
#
#   FILE:  Plugins.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("CWIS Plugins");

# check that the user has sufficient privileges
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

# if form was submitted
if (isset($_POST["SUBMITTED"]))
{
    # for each plugin
    $PManager = $GLOBALS["G_PluginManager"];
    $Attribs = $PManager->GetPluginAttributes();
    foreach ($Attribs as $PluginName => $Attrib)
    {
        # never disable core plugin
        if ($PluginName == "CWISCore") {  continue;  }

        # if plugin has been enabled or disabled
        $FField = "EnabledCheckbox-".$PluginName;
        $PEnabledCurrent = $PManager->PluginEnabled($PluginName) ? TRUE : FALSE;
        $PEnabledNew = isset($_POST[$FField]) ? TRUE : FALSE;
        if ($PEnabledNew != $PEnabledCurrent)
        {
            # updated enable/disable setting to reflect form checkboxes
            $GLOBALS["G_PluginManager"]->PluginEnabled($PluginName, $PEnabledNew);

            # note that plugin has been enabled/disabled
            $PEnabledChange = TRUE;
        }
    }

    # if plugin enabled/disabled status has changed
    if (isset($PEnabledChange))
    {
        # clear page cache
        $GLOBALS["AF"]->ClearPageCache();
    }

    # save any resulting status messages before page is reloaded
    $_SESSION["PluginManagerStatusMessages"] =
            $GLOBALS["G_PluginManager"]->GetStatusMessages();

    # reload page so that correct set of plugins are loaded
    $GLOBALS["AF"]->SetJumpToPage("Plugins");
}
else
{
    # load any status or error messages
    global $H_ErrMsgs;
    global $H_StatusMsgs;
    $H_ErrMsgs = $GLOBALS["G_PluginManager"]->GetErrorMessages();
    if (array_key_exists("PluginManagerStatusMessages", $_SESSION))
    {
        $H_StatusMsgs = $_SESSION["PluginManagerStatusMessages"];
        unset($_SESSION["PluginManagerStatusMessages"]);
    }
    else
    {
        $H_StatusMsgs = $GLOBALS["G_PluginManager"]->GetStatusMessages();
    }
}

