<?PHP
#
#   FILE:  Blog_EntryFactory.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Factory for BlogEntry objects.
*/
class Blog_EntryFactory extends ResourceFactory
{
    /**
    * Create an EntryFactory to manipulate entries for a particular blog.
    * @param $BlogId
    * @return object new Blog_EntryFactory object
    */
    function __construct($BlogId)
    {
        # snag the blog plugin
        $BlogPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("Blog");

        # construct a ResourceFactory for the blog schema
        parent::__construct($BlogPlugin->GetSchemaId());
        # record which ControlledName corresponds with our blog
        $this->BlogCName = new ControlledName( $BlogId );
    }

    /**
    * List all the ItemIds that belong to this blog.
    * @see ItemFactory::GetItemIds() for parameter desciptions.
    */
    function GetItemIds($Condition = NULL, $IncludeTempItems = FALSE,
                        $SortField = NULL, $SortAscending = TRUE)
    {
        return array_intersect(
            parent::GetItemIds($Condition, $IncludeTempItems,
                               $SortField, $SortAscending),
            $this->BlogCName->GetAssociatedResources() );
    }

    /**
    * List ResourceIds for this blog, sorted by a specified field.
    * @see ResourceFactory::GetResourceIdsSortedBy() for prameter descriptions.
    */
    function GetResourceIdsSortedBy($FieldName, $Ascending = TRUE, $Limit = NULL)
    {
        $Matches = array_intersect(
            parent::GetResourceIdsSortedBy($FieldName, $Ascending),
            $this->BlogCName->GetAssociatedResources() );

        return array_slice($Matches, 0, $Limit);
    }

    /**
    * Find blog entries with values that match specified fields.
    * @see ResourceFactory::GetMatchinResources() for parameter descriptions.
    */
    function GetMatchingResources($ValuesToMatch)
    {
        return array_intersect(
            parent::GetMatchingResources($ValuesToMatch),
            $this->BlogCName->GetAssociatedResources() );
    }

    private $BlogCName;
}
