<?PHP
#
#   FILE:  F-Blog_PrintSummaryBlock.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Print given list or given amount of blog entries from given BlogId inside
* of a table element
*
* @param $BlogId the ID of the blog which the entries are from
* @param $NumberOrIdsToPrint (optional, default to NULL) the array of blog IDs,
* 	    or the number of entries to print
*/
function Blog_PrintSummaryBlock($BlogId, $NumberOrIdsToPrint = NULL)
{
    $BlogEntryFactory = new Blog_EntryFactory($BlogId);
    $BlogPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("Blog");
    $NumberToPrint = $BlogPlugin->BlogSetting($BlogId, "EntriesPerPage");
    $CheckEntryValidity = FALSE;
    $GLOBALS["AF"]->LoadFunction("Blog_PrintBlogEntry");

    if ($NumberOrIdsToPrint !== NULL)
    {
        if (is_array($NumberOrIdsToPrint))
        {
            $BlogIds = array_intersect($NumberOrIdsToPrint,
                    $BlogEntryFactory->GetItemIds());
        }
        else
        {
            $NumberToPrint = $NumberOrIdsToPrint;
            $BlogIds = $BlogEntryFactory->GetResourceIdsSortedBy(
                    Blog::PUBLICATION_DATE_FIELD_NAME, FALSE);
        }
    }
    else
    {
        $BlogIds = $BlogEntryFactory->GetResourceIdsSortedBy(
                Blog::PUBLICATION_DATE_FIELD_NAME, FALSE);
    }

    $Printed = 0;

    print "<table class=\"BlogList\">\n<tbody>\n";
    while (($Id = array_shift($BlogIds)) !== NULL
             && $Printed < $NumberToPrint)
    {
        $Entry = new Blog_Entry($Id);
        if ($Entry->UserCanView($GLOBALS["G_User"]))
        {
            Blog_PrintBlogEntry(new Blog_Entry($Id));
            $Printed++;
        }
    }
    print "\n</tbody>\n</table>\n";
}
