<?PHP
#
#   FILE:  Folders_FolderDisplayUI.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2014 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------
class Folders_FolderDisplayUI {
        // @codingStandardsIgnoreStart

    /**
    * Print the given folder.
    * @param int $ResourceFolderId the ID of the user's root folder
    * @param Folder $Folder the folder to print
    * @param Folder|null $Previous previous folder or NULL if at the beginning
    * @param Folder|null $Next next folder or NULL if at the end
    * @param boolean $IsSelected whether or not the folder is selected
    * @return void
    */
  static function PrintFolder($ResourceFolderId, Folder $Folder, $Previous=NULL, $Next=NULL, $IsSelected=FALSE)
    {
        $ItemIds = $Folder->GetItemIds();
        $HasItems = (count($ItemIds) > 0) ? TRUE : FALSE ;
        $IsShared = $Folder->IsShared();

        $HasPrevious = !is_null($Previous);
        $SafePreviousId = ($HasPrevious) ? intval($Previous->Id()) : NULL;

        $HasNext = !is_null($Next);
        $SafeNextId = ($HasNext) ? intval($Next->Id()) : NULL;

        $SafeResourceFolderId = intval($ResourceFolderId);
        $SafeFolderId = intval($Folder->Id());
        $SafeFolderName = defaulthtmlentities($Folder->Name());
        $TruncatedName = NeatlyTruncateString($Folder->Name(), 18);
        $SafeTruncatedName = defaulthtmlentities($TruncatedName);
        $SafeFolderDescription = defaulthtmlentities($Folder->Note());
        $SafeFolderIsShared = defaulthtmlentities($Folder->IsShared());
        $SafeFolderIsSelected = defaulthtmlentities($IsSelected);
        $SafeFolderDescForRollover = defaulthtmlentities(trim(
            strip_tags($Folder->Note())));
        $Offset = isset($_GET["FO".$Folder->Id()]) ? intval($_GET["FO".$Folder->Id()]) : 0 ;
?>

    <div id="Folders_Errors<?PHP print $SafeFolderId?>"></div>
    <div class="cw-section cw-section-elegant cw-html5-section cw-folders-folder" data-parentfolderid="<?PHP print $SafeResourceFolderId; ?>" data-folderid="<?PHP print $SafeFolderId; ?>" data-itemid="<?PHP print $SafeFolderId; ?>">
      <div class="cw-section-header" title="<?PHP print $SafeFolderDescForRollover; ?>">
        <div class="cw-table cw-table-fullsize cw-table-fauxtable">
          <div class="cw-table-fauxrow">
            <div class="cw-table-fauxcell">
              <?PHP if ($IsSelected) { ?>
              <img class="cw-folders-selectedfoldericon" src="<?PHP $GLOBALS["AF"]->PUIFile("asterisk_yellow.png"); ?>" alt="(Current Folder)" />
              <?PHP } ?>
              <a id="cw-folders-nametitle<?PHP print $SafeFolderId; ?>" class="cw-folders-folder-name" href="index.php?P=P_Folders_ViewFolder&amp;FolderId=<?PHP print $SafeFolderId; ?>" data-folderid="<?PHP print $SafeFolderId; ?>">
              <?PHP print $SafeFolderName; ?>  (<?PHP print count($ItemIds)?>)<!-- the whitespace adds to the rendered anchor
              --></a>
            </div>
            <div class="cw-table-fauxcell">
              <div class="cw-folder-actions">
                       <?PHP
                       # Paginate very long folder listings, allowing some overlap from one page to the next
                       #  so that items can be dragged between pages
                       $ItemsPerPage = 500;
                       $Overlap = 50;

                       if (count($ItemIds)>$ItemsPerPage)
                       {
                           # filter the FO (Folder Offset) argument from the URL to use in constructing pagination links
                           $UrlFiltered = preg_replace(
                               '/\&FO'.$Folder->Id().'=[^&]+/', '', $_SERVER["REQUEST_URI"]);

                           print '<span>';
                           if ($Offset>0)
                           {
                               print '<a href="'.$UrlFiltered.'" class="cw-button cw-button-constrained cw-button-elegant">&#124&lt;</a> ';
                               print '<a href="'.$UrlFiltered.'&amp;FO'.$Folder->Id().'='.($Offset-$ItemsPerPage).
                                   '" class="cw-button cw-button-constrained cw-button-elegant"> &lt; </a>';
                           }
                           print " ".$Offset."-".($Offset+($ItemsPerPage+$Overlap) )." ";

                           if ( $Offset + ($ItemsPerPage+$Overlap) < count($ItemIds) )
                           {
                               print '<a href="'.$UrlFiltered.'&amp;FO'.$Folder->Id().'='.($Offset+$ItemsPerPage).
                                   '" class="cw-button cw-button-constrained cw-button-elegant">&gt;</a> ';
                               print '<a href="'.$UrlFiltered.'&amp;FO'.$Folder->Id().'='.(count($ItemIds) - ($ItemsPerPage+$Overlap)).
                                   '" class="cw-button cw-button-constrained cw-button-elegant">&gt&#124;</a>';
                           }
                       } ?>
                  <?PHP if ($GLOBALS["AF"]->GetPageName() == "P_Folders_ManageFolders") { ?>
                  <span title="Making this folder public will allow anyone to view it, including users who are not logged in. To share a folder when it's public, click the folder name to view the folder page and share the URL listed beneath the folder name">
                  <input type="checkbox" id="ShareFolder_<?PHP print $SafeFolderId; ?>" name="Share" data-folderid="<?PHP print $SafeFolderId; ?>" <?PHP if ($IsShared) print 'checked="true"'; ?> />
                  <label for="ShareFolder_<?PHP print $SafeFolderId; ?>">make public</label>
                </span>
                <?PHP if (!$IsSelected) { ?>
                  <a class="cw-button cw-button-constrained cw-button-iconed cw-button-elegant" href="index.php?P=P_Folders_SelectFolder&amp;FolderId=<?PHP print $SafeFolderId; ?>" title="Select this folder as the current folder">
                    <img class="cw-button-icon" src="<?PHP $GLOBALS["AF"]->PUIFile("folder_star.png"); ?>" alt="" />
                    Make Current
                  </a>
                <?PHP } ?>
                <a class="cw-folders-editnamelink cw-button cw-button-constrained cw-button-iconed cw-button-elegant"
                 href="index.php?P=P_Folders_ChangeFolderName&amp;FolderId=<?PHP print $SafeFolderId; ?>"
                 id="cw-folders-foldernamelink<?PHP print $SafeFolderId; ?>"
                 title="Edit the name of this folder"
                 data-folderid="<?PHP print $SafeFolderId?>"
                >
                <img class="cw-button-icon" src="<?PHP $GLOBALS["AF"]->PUIFile("cog.png"); ?>" alt="" />
                Edit Name
                </a>
                <div class="cw-folders-dialog-namechange cw-no-close" id="cw-folders-namechange<?PHP print $SafeFolderId;?>"
                data-ajaxlink="index.php?P=P_Folders_UpdateFolderName&FolderId=<?PHP print $SafeFolderId;?>&FolderName="
                data-folderid="<?PHP print $SafeFolderId?>"
                data-foldername="<?PHP print $SafeTruncatedName; ?>"
                title="Rename ">
                <input type="text" name="FolderName" value="<?PHP print $SafeFolderName; ?>" required="true" />
                </div>
                <a class="cw-button cw-button-constrained cw-button-iconed cw-button-elegant" href="index.php?P=P_Folders_ConfirmDeleteFolder&amp;FolderId=<?PHP print $SafeFolderId; ?>" title="Delete this folder">
                  <img class="cw-button-icon" src="<?PHP $GLOBALS["AF"]->PUIFile("cross.png"); ?>" alt="" />
                  Delete
                </a>
                <?PHP if ($HasItems) {?>
                <a class="cw-folders-clear-confirmlink cw-button cw-button-constrained cw-button-iconed cw-button-elegant"
                 href="index.php?P=P_Folders_RemoveAllItems&amp;FolderId=<?PHP print $SafeFolderId; ?>"
                 id="cw-folders-folderlink<?PHP print $SafeFolderId; ?>"
                 title="Remove all resources from this folder"
                 data-parentfolderid="<?PHP print $SafeFolderId; ?>"
                 data-folderid="<?PHP print $SafeFolderId?>"
                >
                <img class="cw-button-icon" src="<?PHP $GLOBALS["AF"]->PUIFile("cross.png"); ?>" alt="" />
                Clear
                </a>
                <div class="cw-dialog-confirm cw-no-close" id="cw-folders-folderclear<?PHP print $SafeFolderId?>" title="Clear <?PHP print $SafeTruncatedName; ?>">
                Clear contents of folder <em><?PHP print $SafeFolderName; ?></em>?
                </div>
              <?PHP }?>
                <noscript>
                  <?PHP if ($HasPrevious) { ?>
                    <a class="cw-button cw-button-constrained cw-button-elegant" href="index.php?P=P_Folders_MoveItem&amp;FolderId=<?PHP print $SafeResourceFolderId; ?>&amp;TargetItemId=<?PHP print $SafeFolderId; ?>&amp;ItemId=<?PHP print $SafePreviousId; ?>" title="Move this folder up">
                      &uarr;
                    </a>
                  <?PHP } else { ?>
                    <span class="cw-button cw-button-constrained cw-button-active cw-button-elegant" title="This folder cannot be moved up because it is at the top of the list">&uarr;</span>
                  <?PHP } ?>
                  <?PHP if ($HasNext) { ?>
                    <a class="cw-button cw-button-constrained cw-button-elegant" href="index.php?P=P_Folders_MoveItem&amp;FolderId=<?PHP print $SafeResourceFolderId; ?>&amp;TargetItemId=<?PHP print $SafeNextId; ?>&amp;ItemId=<?PHP print $SafeFolderId; ?>" title="Move this folder down">
                      &darr;
                    </a>
                  <?PHP } else { ?>
                    <span class="cw-button cw-button-constrained cw-button-active cw-button-elegant" title="This folder cannot be moved down because it is at the bottom of the list">&darr;</span>
                  <?PHP } ?>
                  <a class="cw-button cw-button-constrained cw-button-elegant" href="index.php?P=P_Folders_ChangeFolderName&amp;FolderId=<?PHP print $SafeFolderId; ?>">Rename</a>
                  <?PHP if (!$IsShared) { ?>
                    <a class="cw-button cw-button-constrained cw-button-elegant" href="index.php?P=P_Folders_ShareFolder&amp;FolderId=<?PHP print $SafeFolderId; ?>" title="Make this folder publicly accessible">
                      Make Public
                    </a>
                  <?PHP } else { ?>
                    <a class="cw-button cw-button-constrained cw-button-elegant" href="index.php?P=P_Folders_WithdrawFolder&amp;FolderId=<?PHP print $SafeFolderId; ?>" title="Make this folder publicly inaccessible">
                      Make Private
                    </a>
                  <?PHP } ?>
                </noscript>
                <?PHP $GLOBALS["AF"]->SignalEvent("EVENT_HTML_INSERTION_POINT",
                  array("PageName" => $GLOBALS["AF"]->GetPageName(),
                        "Location" => "Folder Buttons",
                        "Context" => array("FolderId" => $Folder->Id()) )); ?>
               <?PHP } ?>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="cw-section-body">
        <ul class="cw-list cw-list-dematte cw-list-dotlist cw-list-noindent cw-folders-items cw-folders-items-mini" data-folderid="<?PHP print $SafeFolderId; ?>">
          <?PHP if (!$HasItems) { ?>
          <li class="cw-folders-noitems">There are no items in this folder.</li>
          <?PHP } else {
           # if we're not at the beginning of the folder, put a hidden placeholder item
           #  so that dragging things to the top of what is currently displayed doesn't
           # put them all the way at the beginning of the folder
           if ($Offset>0)
               self::PrintFolderItem($Folder->Id(), $ItemIds[$Offset-1], TRUE);

           # slice off the items to display, show them
           $ItemIds = array_slice($ItemIds, $Offset, 550);
           foreach ($ItemIds as $ItemId)
               self::PrintFolderItem($Folder->Id(), $ItemId);
           } ?>
        </ul>
      </div>
    </div>
<?PHP
    }

    /**
    * Print the folder item with the given ID.
    * @param string|int $FolderId ID of the folder in which the item is
    * @param string|int $ItemId item ID
    * @param bool $Hidden if the item should be hidden with css
    * @return void
    */
    private static function PrintFolderItem($FolderId, $ItemId, $Hidden = FALSE)
    {
        $Resource = new Resource($ItemId);
        $SafeFolderId = defaulthtmlentities($FolderId);
        $SafeId = defaulthtmlentities($Resource->Id());
        $SafeTitle = Folders_Common::GetSafeResourceTitle($Resource);
        ?>
      <li data-parentfolderid="<?PHP print $SafeFolderId; ?>" data-itemid="<?PHP print $SafeId; ?>"
           <?PHP if ($Hidden) { ?> style="display: none;" <?PHP } ?> >
      <a href="index.php?P=FullRecord&amp;ID=<?PHP print $SafeId; ?>">
        <?PHP print $SafeTitle; ?>
      </a>
    </li>
<?PHP
        // @codingStandardsIgnoreEnd
    }

}
