<?PHP
#
#   FILE:  MySearches.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2002-2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Displays data for the UI about a user's saved searches and recent searches.
*/
class MySearches extends Plugin {

    # ---- STANDARD PLUGIN INTERFACE -----------------------------------------

    /**
    * Register information about this plugin.
    */
    function Register()
    {
        $this->Name = "My Searches";
        $this->Version = "1.0.0";
        $this->Description = "Provides data for the UI via events"
                ." about a user's saved searches and recent searches.";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
                "CWISCore" => "3.2.0");
        $this->EnabledByDefault = FALSE;

        $this->CfgSetup["RecentSearches"] = array(
                "Type" => "Flag",
                "Label" => "Show Recent Searches",
                "Default" => "Yes",
                "Help" => "Display recent searches information.",
                "OnLabel" => "Yes",
                "OffLabel" => "No",
                );

        $this->CfgSetup["MySearches"] = array(
                "Type" => "Flag",
                "Label" => "Show My Searches",
                "Default" => "Yes",
                "Help" => "Display users' searches information.",
                "OnLabel" => "Yes",
                "OffLabel" => "No",
                );
    }

    /**
    * Initialize default settings.
    */
    function Initialize()
    {
        # add extra function dirs that we need
        # these are listed in reverse order because each will be added to the
        # beginning of the search list
        $GLOBALS["AF"]->AddFunctionDirectories(array(
            "plugins/".__CLASS__."/interface/default/include/",
            "plugins/".__CLASS__."/interface/%ACTIVEUI%/include/",
            "local/plugins/".__CLASS__."/interface/default/include/",
            "local/plugins/".__CLASS__."/interface/%ACTIVEUI%/include/"));
    }

    /**
    * Hook the events into the application framework.
    * @return Returns an array of events to be hooked into the application
    *      framework.
    */
    function HookEvents()
    {
      return array("EVENT_HTML_INSERTION_POINT" => array("PrintMySearches","PrintRecentSearches"),
                  );
    }


    # ---- HOOKED METHODS ----------------------------------------------------

    /**
    * Print the My Searches UI content
    */
    function PrintMySearches($PageName, $Location, $Context=NULL)
    {
      if($this->ConfigSetting("MySearches") == "Yes" && $Location=="Sidebar Content" )
      {
        global $G_User;

        $Searches = GetSavedSearchesForUser($G_User->Id());
        $SearchesForDisplay = array();

        if (count($Searches))
        {
          $GLOBALS["AF"]->LoadFunction("PrintMySearchesSidebarBlock");
          foreach ($Searches as $Search) {
            $DisplaySearch = array(
                            "SearchURL" => "index.php?P=AdvancedSearch&amp;Q=Y&amp;".$Search->GetSearchGroupsAsUrlParameters(),
                            "SearchTitle" => $Search->GetSearchGroupsAsTextDescription(NULL,
                                                                                       TRUE,
                                                                                       FALSE,
                                                                                       30
                                                                                       ),
                            "SearchName" => $Search->SearchName(),
                            );
            array_push($SearchesForDisplay, $DisplaySearch);
          }
          PrintMySearchesSidebarBlock($SearchesForDisplay);
        }
      }
    }

    /**
    * Print the Recent Searches UI content
    */
    function PrintRecentSearches($PageName, $Location, $Context=NULL)
    {
      if($this->ConfigSetting("RecentSearches") == "Yes" && $Location=="Sidebar Content" )
      {
        global $G_User;
        # recent searches display
        $EventLog = new SPTEventLog();
        if ($G_User->IsLoggedIn())
        {
            $EventLog->LimitFindToUser();
            $SearchesForDisplay = array();
            $Searches = $EventLog->FindEvents(NULL, NULL, 0, 50,
                    SptEventLog::SPTEVENT_SEARCH, SptEventLog::SPTEVENT_ADVANCEDSEARCH);
        }
        elseif (FALSE)  // (need to add system configuration option to disable before allowing this)
        {
            $EventLog->AddSqlConditionForFind("UserId >= 0");
            $Searches = $EventLog->FindEvents(NULL, NULL, 0, 50, SptEventLog::SPTEVENT_SEARCH);
        }
        if (isset($Searches) && count($Searches))
        {
          $SearchesForDisplay = array();

          $DisplayedSearches = array();
         foreach ($Searches as $Search)
         {
           if (!isset($DisplayedSearches[$Search["DataOne"]]) && count($SearchesForDisplay) <= 5)
           {
               $DisplayedSearches[$Search["DataOne"]] = TRUE ;
               $DisplaySearch = array(
                                 "SearchURL" => "index.php?P=AdvancedSearch&amp;Q=Y&amp;".$Search["DataOne"],
                                 "SearchName" => "\n".SavedSearch::TranslateSearchGroupsToTextDescription(
                                                                SavedSearch::TranslateUrlParametersToSearchGroups($Search["DataOne"]),
                                                                                                                   TRUE, FALSE, 30),
                                 );
               array_push($SearchesForDisplay, $DisplaySearch);
           }

         }
          $GLOBALS["AF"]->LoadFunction("PrintRecentSearchesSidebarBlock");
          PrintRecentSearchesSidebarBlock($SearchesForDisplay);
        }
      }
    }

}
