ALTER TABLE MetadataFields ADD COLUMN UpdateMethod
  ENUM("NoAutoUpdate","OnRecordCreate","Button","OnRecordEdit",
       "OnRecordChange") DEFAULT "NoAutoUpdate";

UPDATE MetadataFields SET UpdateMethod="OnRecordCreate"
  WHERE FieldName="Date of Record Creation";

UPDATE MetadataFields SET UpdateMethod="OnRecordChange"
  WHERE FieldName="Date Last Modified";

ALTER TABLE SystemConfiguration ADD COLUMN TitleField INT DEFAULT -1;
ALTER TABLE SystemConfiguration ADD COLUMN DescriptionField INT DEFAULT -1;
ALTER TABLE SystemConfiguration ADD COLUMN UrlField INT DEFAULT -1;
ALTER TABLE SystemConfiguration ADD COLUMN ScreenshotField INT DEFAULT -1;
ALTER TABLE SystemConfiguration ADD COLUMN SecureLogin INT DEFAULT 1;
ALTER TABLE SystemConfiguration ADD COLUMN MailChangeMailSubject TEXT;
ALTER TABLE SystemConfiguration ADD COLUMN MailChangeMailBody TEXT;

UPDATE SystemConfiguration SET MailChangeMailSubject = 'X-PORTALNAME-X Email Address Change Request' WHERE MailChangeMailSubject IS NULL;
UPDATE SystemConfiguration SET MailChangeMailBody = 'Someone (presumably you) has requested that the email address registered at X-PORTALNAME-X for the account X-USERNAME-X be changed from X-EMAILADDRESS-X to X-NEWEMAILADDRESS-X.\n\nTo confirm this change, please click on this link:\n\n  X-CHANGEURL-X\n\nIf that link doesn\'t work you can also go to this address:\n\n  X-MANUALCHANGEURL-X\n\nAnd enter your user name and confirmation code:\n\n   Name:  X-USERNAME-X\n\n   Code:  X-CHANGECODE-X\n\nIf you don\'t want to change your email, just ignore this message and nothing will be done.\n\nFor reference, the password change request came from address X-IPADDRESS-X and this e-mail was sent to X-NEWEMAILADDRESS-X' WHERE MailChangeMailBody IS NULL;

UPDATE SystemConfiguration SET TitleField = (SELECT FieldId FROM MetadataFields WHERE FieldName = 'Title') WHERE TitleField = -1;
UPDATE SystemConfiguration SET DescriptionField = (SELECT FieldId FROM MetadataFields WHERE FieldName = 'Description') WHERE DescriptionField = -1;
UPDATE SystemConfiguration SET UrlField = (SELECT FieldId FROM MetadataFields WHERE FieldName = 'Url') WHERE UrlField = -1;
UPDATE SystemConfiguration SET ScreenshotField = (SELECT FieldId FROM MetadataFields WHERE FieldName = 'Screenshot') WHERE ScreenshotField = -1;

ALTER TABLE APUsers ADD COLUMN SearchSelections TEXT;
ALTER TABLE APUsers ADD COLUMN EMailNew TEXT;

ALTER TABLE PluginInfo ADD COLUMN Cfg TEXT;

ALTER TABLE ApplicationFrameworkSettings DROP COLUMN MaxTaskTime;
ALTER TABLE ApplicationFrameworkSettings ADD COLUMN MaxExecTime INT DEFAULT 300;
CREATE TABLE IF NOT EXISTS RunningTasks (
    TaskId      INT,
    Callback    MEDIUMTEXT,
    Parameters  MEDIUMTEXT,
    Priority    INT,
    Description TEXT,
    StartedAt   TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    CrashInfo   TEXT,
    INDEX       (TaskId),
    INDEX       (Callback(64), Parameters(256))
);
ALTER TABLE TaskQueue ADD INDEX (Callback(64), Parameters(256));
ALTER TABLE TaskQueue MODIFY COLUMN Callback MEDIUMTEXT;
ALTER TABLE TaskQueue MODIFY COLUMN Parameters MEDIUMTEXT;

CREATE TABLE IF NOT EXISTS ResourceCounts (
    FieldId INT,
    ClassName TEXT,
    CountType TEXT,
    Count INT
);

INSERT INTO ResourceCounts (FieldId, ClassName, CountType, Count)
    SELECT * FROM (SELECT -1, '__LAST_UPDATED__', '',0) AS Tmp
    WHERE NOT EXISTS (
            SELECT ClassName FROM ResourceCounts WHERE ClassName = '__LAST_UPDATED__'
            ) LIMIT 1;
