<?PHP
#
#   FILE:  ConfirmRemoveUser.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to return true if users have been selected for removal
function RemoveUsersExist()
{
    global $G_UserRemoveArray;

    return count($G_UserRemoveArray);
}

function PrintUserList()
{
    global $G_UserRemoveArray;

    foreach ($G_UserRemoveArray as $UserId)
    {
        $RemoveUser = new CWUser(intval($UserId));
        print $RemoveUser->Get("UserName")."<br>";
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $G_UserRemoveArray;
global $H_TriedRemovingOwnAccount;

PageTitle("Confirm Remove User");

# check if current user is authorized
CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN);

# get the list of users to remove
$G_UserRemoveArray = GetArrayValue($_SESSION, "UserRemoveArray", array() );

# check if the user is trying to remove his or her own account
$OwnIdKey = array_search($GLOBALS["User"]->Id(), $G_UserRemoveArray);
$H_TriedRemovingOwnAccount = FALSE;

# the user tried to remove his or her own account, so don't allow it
if ($OwnIdKey !== FALSE)
{
    $H_TriedRemovingOwnAccount = TRUE;
    unset($G_UserRemoveArray[$OwnIdKey]);
}

# pass along the values to the removal page
$_SESSION["OkayToRemoveUsers"] = 1;
$_SESSION["UserRemoveArray"] = $G_UserRemoveArray ;
