<?PHP
#
#   FILE:  DownloadFile.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function OutputFile($Path)
{
    $Handle = @fopen($Path, "rb");

    if (FALSE === $Handle)
    {
        # couldn't open the file, just return to avoid further errors
        return;
    }

    while (!feof($Handle))
    {
        # send the file in 500 KB chunks
        echo fread($Handle, 512000);
        flush();
    }

    fclose($Handle);
}

# ----- MAIN -----------------------------------------------------------------

$Id = GetArrayValue($_GET, "ID", GetArrayValue($_GET, "Id"));

# if file ID was supplied
if (!is_null($Id))
{
    $FileId = intval($Id);
    $File = new File($FileId);

    # if file info was loaded successfully
    if ($File->Status() == File::FILESTAT_OK)
    {
        $Schema = new MetadataSchema();
        $Field = $Schema->GetField($File->FieldId());
        $Resource = new Resource($File->ResourceId());

        # if user can view file
        if ($Resource->UserCanViewField($User, $Field))
        {
            $Filepath = $File->GetNameOfStoredFile();
            $Mimetype = $File->GetMimeType();

            # if we don't have a MIME type, try to determine it
            if (!$Mimetype)
            {
                if (function_exists("finfo_open"))
                {
                    $FInfoHandle = finfo_open(FILEINFO_MIME);

                    if ($FInfoHandle)
                    {
                        $FInfoMime = finfo_file($FInfoHandle,
                                $File->GetNameOfStoredFile());
                        finfo_close($FInfoHandle);

                        if ($FInfoMime)
                        {
                            $Mimetype = $FInfoMime;
                        }
                    }
                }
                else if (function_exists("mime_content_type"))
                {
                    # mime_content_type has been deprecated, but it may be
                    # the only way to get the mimetype for PHP < 5.3
                    $FileType = mime_content_type($File->GetNameOfStoredFile());

                    if ($FileType)
                    {
                        $Mimetype = $FileType;
                    }
                }
            }

            # if we still don't have a MIME type, use a fallback
            if (!$Mimetype) $Mimetype = "application/octet-stream";

            # set headers to download file
            header("Content-Type: ".$Mimetype);
            header("Content-Length: ".$File->GetLength());
            if (!$GLOBALS["G_PluginManager"]->PluginEnabled("CleanURLs")){
              header("Content-Disposition: attachment; filename='".$File->Name()."'");
            }

            # send file to user, but unbuffered to avoid memory issues
            $AF->AddUnbufferedCallback('OutputFile', array($Filepath));

            $AF->SuppressHTMLOutput();
        }

        else
        {
            CheckAuthorization(-1);
        }
    }
}

# if a file was not found, the HTML template will be loaded instead
