<?PHP
#
#   FILE:  SelectEditUserListComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2003-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# confirm remove user(s)
function ConfirmRemoveUsers()
{
    $UserRemoveArray = array();

    reset($_POST);
    while (list($Var, $Value) = each ($_POST))
    {
        if (preg_match("/userid_([0-9]+)/", $Var))
        {
            if (isset($Value))
            {
                $UserRemoveArray[] = intval($Value);
            }
        }
    }

    $_SESSION["UserRemoveArray"] = $UserRemoveArray;

    $GLOBALS["AF"]->SetJumpToPage("ConfirmRemoveUser");
}

# remove user(s)
function RemoveUsers()
{
    $UserRemoveArray = GetArrayValue($_SESSION, "UserRemoveArray", array());

    foreach ($UserRemoveArray as $UserId)
    {
        # don't let a user delete his or her own account
        if ($UserId == $GLOBALS["User"]->Id())
        {
            continue;
        }

        $RemoveUser = new CWUser(intval($UserId));
        $GLOBALS["AF"]->SignalEvent("EVENT_USER_DELETED", array("UserId" => $RemoveUser->Id()));
        $RemoveUser->Delete();
    }

    unset($_SESSION["UserRemoveArray"]);
    unset($_SESSION["OkayToRemoveUsers"]);

    $GLOBALS["AF"]->SetJumpToPage("UserList");
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
if (!CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN)) {  return;  }

# grab entry information from database
$DB = new Database();

$Submit = $_POST["Submit"];

# check for Cancel button from previous screen
if ($Submit == "Cancel")
{
    $AF->SetJumpToPage("UserList");
}
else if (substr($Submit, 0, 6) == "Remove")
{
    # OK to remove selected user?
    if (isset($_SESSION["OkayToRemoveUsers"]))
    {
        RemoveUsers();
    }
    # build array list of users to remove
    else
    {
        ConfirmRemoveUsers();
    }
}
