<?PHP
#
#   FILE:  BatchEdit.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2014 Internet Scout Project
#   http://scout.wisc.edu/cwis/
#

class BatchEdit extends Plugin
{
    /**
    * Register information about this plugin.
    */
    public function Register()
    {
        $this->Name = "Batch Editing";
        $this->Version = "1.0.0";
        $this->Description = "Allows resources in a folder to be edited en masse.";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
            "CWISCore" => "2.4.1",
            "Folders" => "1.0.7"
            );
        $this->EnabledByDefault = FALSE;

        $this->CfgSetup["AllowedFields"] = array(
            "Type" => "MetadataField",
            "Label" => "Allowed Fields",
            "Help" => "Fields allowed for bulk editing",
            "AllowMultiple" => TRUE,
            "FieldTypes" => MetadataSchema::MDFTYPE_TEXT |
                            MetadataSchema::MDFTYPE_PARAGRAPH |
                            MetadataSchema::MDFTYPE_NUMBER |
                            MetadataSchema::MDFTYPE_DATE |
                            MetadataSchema::MDFTYPE_TIMESTAMP |
                            MetadataSchema::MDFTYPE_FLAG |
                            MetadataSchema::MDFTYPE_TREE |
                            MetadataSchema::MDFTYPE_CONTROLLEDNAME |
                            MetadataSchema::MDFTYPE_OPTION |
                            MetadataSchema::MDFTYPE_URL |
                            MetadataSchema::MDFTYPE_REFERENCE,
            "Default" => array(),
            );

        $this->CfgSetup["RequiredPrivs"] = array(
            "Type" => "Privileges",
            "Label" => "Required Privileges",
            "AllowMultiple" => TRUE,
            "Help" => "Users with any of the selected privileges will "
                      ."be able to perform batch edits on fields they are otherwise "
                      ."able to edit (i.e. only those they could edit from the "
                      ."Edit Resource page)",
            "Default" => array( PRIV_SYSADMIN ),
            );
    }

    /**
    * Hook the events into the application framework.
    * @return an array of events to be hooked into the application framework
    */
    public function HookEvents()
    {
        return array(
            "EVENT_HTML_INSERTION_POINT" => "InsertButton",
            );
    }

    /**
    * HTML insertion point handler, used to add a 'bulk edit' button
    * to the manage folders page.
    * @param string $PageName of currently loaded page.
    * @param string $Location where HTML can be inserted.
    * @param mixed $Context containing page-defined context data.
    */
    public function InsertButton($PageName, $Location, $Context=NULL)
    {
        if ($Location == "Folder Buttons")
        {
            if ($GLOBALS["G_User"]->IsLoggedIn() &&
                $GLOBALS["G_User"]->HasPriv($this->ConfigSetting("RequiredPrivs")) )
            {
                $Folder = new Folders_Folder($Context["FolderId"]);

                if ($Folder->GetItemCount()>0)
                {
                    if ($PageName == "P_Folders_ManageFolders")
                    {
                        print('<a href="index.php?P=P_BatchEdit_Edit&amp;FI='
                              .$Context["FolderId"]
                              .'" class="cw-button cw-button-constrained cw-button-elegant '
                              .'bulk-edit-button">Batch Edit</a>');
                    }
                    else if ($PageName == "P_Folders_ViewFolder")
                    {
                        print('<a href="index.php?P=P_BatchEdit_Edit&amp;FI='
                              .$Context["FolderId"]
                              .'" class="cw-button cw-button-elegant '
                              .'bulk-edit-button">Batch Edit</a>');
                    }
                }
            }
        }
    }
}
