<?PHP
#
#   FILE:  Edit.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2014 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

global $H_FUI, $H_Folder, $H_ChangedResources;

$MyPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("BatchEdit");

# make sure the user is allowed to do batch editing
CheckAuthorization($MyPlugin->ConfigSetting("RequiredPrivs"));

$H_Folder = new Folders_Folder(intval($_GET["FI"]));
$H_FUI = new FieldEditingUI("Test");

$H_FUI->AddFieldButton("Add Field", $MyPlugin->ConfigSetting("AllowedFields"));

$H_ChangedResources = array();

if (isset($_POST["Submit"]) && $_POST["Submit"] == "Apply Changes")
{
    $ChangeData = $H_FUI->GetValuesFromFormData();

    foreach ($H_Folder->GetItemIds() as $ResourceId)
    {
        $Resource = new Resource($ResourceId);

        $WasChanged = FieldEditingUI::ApplyChangesToResource($Resource, $GLOBALS["G_User"], $ChangeData);

        if ($WasChanged)
        {
            $H_ChangedResources [] = $Resource;
        }
    }
}
