<?PHP
#
#   FILE:  F-Blog_PrintBlogEntry.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Print a blog entry.
* @param Blog_Entry $Entry Blog entry to print.
*/
function Blog_PrintBlogListItem(Blog_Entry $Entry)
{
    $Blog = $GLOBALS["G_PluginManager"]->GetPlugin("Blog");
    $SafeId = defaulthtmlentities($Entry->Id());
    $SafeTitle = defaulthtmlentities(NeatlyTruncateString($Entry->TitleForDisplay(), 32));
    $SafeAuthor = defaulthtmlentities($Entry->AuthorForDisplay());
    $SafeEditor = defaulthtmlentities($Entry->EditorForDisplay());
    $SafeCreationDate = defaulthtmlentities($Entry->CreationDateForDisplay());
    $SafeModificationDate = defaulthtmlentities($Entry->ModificationDateForDisplay());
    $SafePublicationDate = defaulthtmlentities($Entry->PublicationDateForDisplay());

    $EntryFromEmailBlog = ($Entry->GetBlogId() ==
                           $Blog->ConfigSetting("EmailNotificationBlog"));

    // @codingStandardsIgnoreStart
?>
  <tr class="blog-list_entry">
    <td><a href="index.php?P=P_Blog_Entry&amp;ID=<?PHP print $SafeId; ?>"><?PHP print $SafeTitle; ?></a></td>
    <td><?PHP print $SafeAuthor; ?></td>
    <td><?PHP print $SafeEditor; ?></td>
    <td><?PHP print $SafeCreationDate; ?></td>
    <td><?PHP print $SafeModificationDate; ?></td>
    <td><?PHP print $SafePublicationDate; ?></td>
    <td class="blog-actions">
      <a class="cw-button cw-button-elegant cw-button-constrained"
         title="View this blog entry"
         href="index.php?P=P_Blog_Entry&amp;ID=<?PHP print $SafeId; ?>"
         >View</a>
      <a class="cw-button cw-button-elegant cw-button-constrained"
         title="Edit this blog entry"
         href="index.php?P=EditResource&amp;ID=<?PHP print $SafeId; ?>"
         >Edit</a>

      <?PHP if ($EntryFromEmailBlog) { ?>
      <?PHP if ($Blog->NotificationsCouldBeSent($Entry, $GLOBALS["G_User"])) { ?>
        <a class="cw-button cw-button-elegant cw-button-constrained"
           title="Send e-mail notifications to subscribers about this blog entry"
           href="index.php?P=P_Blog_ConfirmNotifySubscribers&amp;ID=<?PHP print $SafeId; ?>"
           >Notify</a>
      <?PHP } else if ($Blog->NotificationsCouldBeSent()) { ?>
        <a class="cw-button cw-button-elegant cw-button-constrained cw-button-disabled"
           title="E-mail notifications have already been sent for this blog entry"
           >Notify</a>
      <?PHP } ?>
      <?PHP } else { ?>
        <a class="cw-button cw-button-elegant cw-button-constrained cw-button-disabled"
           title="This entry does not belong to email-notification blog selected in the configuration setting"
           >Notify</a>
      <?PHP } ?>
      <form method="post"
            action="index.php?P=EditResourceComplete&amp;ID=<?PHP print $SafeId; ?>"
            class="blog-delete">
        <input class="cw-button cw-button-elegant cw-button-constrained"
               type="submit"
               name="Submit"
               title="Permanently delete this blog entry"
               value="Delete" />
      </form>
    </td>
  </tr>
<?PHP
    // @codingStandardsIgnoreEnd
}
