<?PHP

/**
* Display the 'Add All Search Results to the Current Folder' button.
* @param boolean $TooManyResources whether the search results exceed the maxium
* number of resources that can be added to the current folder.
* @param int $MaxResources the maxium number of resources that can be added
* to the current folder.
* @param string $AddAllUrl the string URL to add all search results to the current folder.
*/
function Folders_InsertAllButtonHTML($TooManyResources, $MaxResources, $AddAllUrl)
{
    $ButtonStyleClasses = "cw-button cw-button-elegant cw-button-iconed cw-button-constrained ";
  ?>
    <!-- BEGIN FOLDER ALL BUTTON DISPLAY -->
    <div id="Folders_AddAllResourcesResponse">
    </div>
    <?PHP
    if(!$TooManyResources)
    {
    // @codingStandardsIgnoreStart
    ?>
      <a class="cw-button cw-button-iconed cw-button-elegant cw-folders-addallsearch" href="<?PHP print defaulthtmlentities($AddAllUrl)?>"
         title="Add the results of this search to your current folder."
         data-buttonclasses="<?php print $ButtonStyleClasses; ?>">
          <img class="cw-button-icon" src="<?PHP $GLOBALS["AF"]->PUIFile("folder_add.png"); ?>" alt="" />
          Add All to Folder
        </a>
    <?PHP
    }
    else
    {
    ?>
        <a class="cw-button cw-button-iconed cw-button-disabled cw-button-elegant" title="Only <?PHP print defaulthtmlentities($MaxResources); ?> search results can be added to a folder at a time. Refine your search to reduce the amount of search results.">
          <img class="cw-button-icon" src="<?PHP $AF->PUIFile("folder_add.png"); ?>" alt="" />
          Add All to Folder
        </a>
    <?PHP
    // @codingStandardsIgnoreEnd
    }
    ?>
    <!-- END FOLDER ALL BUTTON DISPLAY -->
  <?PHP
}
