<?PHP
#
#   FILE:  RemoveAllItems.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

global $AF;

$FolderId = GetArrayValue($_GET, "FolderId");

# if "ReturnTo" is set, then jump back to that address
if (GetArrayValue($_GET, "ReturnTo", FALSE))
{
    $AF->SetJumpToPage(urldecode($_GET["ReturnTo"]));
}
# else jump back to the page which this page is being directed from
else if (isset($_SERVER["HTTP_REFERER"]))
{
    $AF->SetJumpToPage($_SERVER["HTTP_REFERER"]);
}
# jump to ViewFolder page if nothing is set
else
{
    $AF->SetJumpToPage($GLOBALS["AF"]->
        GetCleanUrlForPath("index.php?P=P_Folders_ViewFolder&FolderId=".$FolderId));
}

#check if user is logged in
if($User->IsLoggedIn())
{
  $FolderFactory = new Folders_FolderFactory($User->Id());
  $ResourceFolder = $FolderFactory->GetResourceFolder();
  $Folder = new Folders_Folder($FolderId);
  $ItemsInFolder = $Folder->GetItemIds();

  #check if the user owns the folder
  if($User->Id() == $Folder->OwnerId()){
    foreach($ItemsInFolder as $ItemId)
    {
      $Folder->RemoveItem($ItemId);
    }
  }
  else{
    #user doesn't own this folder.
    return;
  }
}
else {
  #user isn't logged in.
  return;
}
