<?PHP
#
#   FILE:  Subscribe.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

# make sure our plugin is enabled, bounce to Home if not
if (!$GLOBALS["G_PluginManager"]->PluginEnabled("MailingList"))
{
    $GLOBALS["AF"]->SetJumpToPage("Home");
    return;
}


$Jump = urlencode(GetArrayValue($_GET, "ReturnTo", "Home"));
$H_List = GetArrayValue($_GET, "List", NULL);

if ($GLOBALS["G_User"]->IsLoggedIn())
{
    $GLOBALS["AF"]->SuppressHTMLOutput();

    if ($H_List !== NULL)
    {
        $MyPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("MailingList");
        $MyPlugin->Subscribe( $GLOBALS["G_User"], $H_List );
        $GLOBALS["AF"]->SetJumpToPage($Jump);
    }
    else
    {
        $GLOBALS["AF"]->SetJumpToPage("Preferences");
    }
}
else
{
    $AdditionalErrorMessages =
        UserEditingUI::GetAdditionalErrorCodes(
            isset($_GET["F_EMail"]) ? $_GET["F_EMail"] : "" );

    # set up friendly error messages for the incoming form
    $AdditionalErrorMessages["E_NO_SUCH_LIST"]
        = "No such mailing list";
    $AdditionalErrorMessages["E_NO_LIST_SPECIFIED"]
        = "No mailing list provided" ;

    $AdditionalErrorMessages =
        $GLOBALS["AF"]->SignalEvent(
            "EVENT_USER_SIGNUP_EXTEND_ERROR_LIST",
                array($AdditionalErrorMessages));

    $H_FTool = new FormTool(
        MailingList::GetSubscriptionFormFields(),
        array_shift($AdditionalErrorMessages));
    $H_FTool->SetFieldValuesFromUrlParams();
}
