<?PHP
#
#   FILE:  CollectionReports.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("User Statistics");

# make sure user has sufficient permission to view report
if (!CheckAuthorization(PRIV_COLLECTIONADMIN)) {  return;  }


# Grab ahold of the relevant metrics objects:
$Recorder = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsRecorder");
$Reporter = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsReporter");

#
# Regular users vs time:
#
$RegUserCountData = array();
foreach ( $Recorder->GetSampleData(MetricsRecorder::ST_REGUSERCOUNT ) as
          $SampleDate => $SampleValue )
{
    $TS = strtotime( date("Y-m-d", strtotime($SampleDate) ) );
    $RegUserCountData[ $TS ] = array( $SampleValue );
}
ksort( $RegUserCountData );

$H_UserCountGraph = new Graph(Graph::TYPE_DATE, $RegUserCountData );
$H_UserCountGraph->XLabel("Date");
$H_UserCountGraph->YLabel("Number of Registered Users");

#
# Privileged users vs time:
#
$PrivUserCountData = array();
foreach ($Recorder->GetSampleData(MetricsRecorder::ST_PRIVUSERCOUNT ) as
         $SampleDate => $SampleValue )
{
    $TS = strtotime( date("Y-m-d", strtotime($SampleDate) ) );
    $PrivUserCountData[ $TS ] = array( $SampleValue );
}
ksort( $PrivUserCountData );

$H_PrivUserCountGraph = new Graph(Graph::TYPE_DATE, $PrivUserCountData );
$H_PrivUserCountGraph->XLabel("Date");
$H_PrivUserCountGraph->YLabel("Number of Privileged Users");

#
# New users per day
#
$NewUsersPerDay   = array();

# Pull the metrics data:
foreach ( $Recorder->GetSampleData(MetricsRecorder::ST_DAILYNEWACCTS ) as
          $SampleDate => $SampleValue )
{
    # Discard the 'time' part of the timestamp:
    $SampleTS = strtotime($SampleDate);
    $DayTS  = strtotime( date("Y-m-d", $SampleTS) );

    # Make sure we haven't seen this day already,
    #  don't record stats when we had zero things,
    #  and make sure that the value recorded is sane:
    if (isset($NewUsersPerDay[$DayTS]) ||
        $SampleValue == 0 ||
        $SampleValue > 1000)
        continue;

    # Compute summaries:
    $NewUsersPerDay[$DayTS] = array($SampleValue);
}

# Generate the graphs:
$H_NewUsersDay   = new Graph(Graph::TYPE_DATE_BAR, $NewUsersPerDay);
$H_NewUsersDay->XLabel("Date");
$H_NewUsersDay->YLabel("New User Registrations");
$H_NewUsersDay->Scale(Graph::WEEKLY);

#
# Number of logins per (day/week/mo) bar charts
#
$LoginsPerDay   = array();

# Pull out the metrics data:
foreach ( $Recorder->GetSampleData(MetricsRecorder::ST_DAILYLOGINCOUNT ) as
          $SampleDate => $SampleValue )
{
    # Discard the 'time' part of the timestamp
    $SampleTS = strtotime($SampleDate);
    $DayTS  = strtotime( date("Y-m-d", $SampleTS) );

    # Make sure we haven't seen this day before,
    #  skip stats for days with no logins,
    #  and make sure the value we're getting makes sense:
    if (isset($LoginsPerDay[$DayTS]) ||
        $SampleValue == 0 ||
        $SampleValue > 2000 )
        continue;

    # Compute metrics sumamries:
    $LoginsPerDay[$DayTS] = array($SampleValue);
}

# Generate graphs:
$H_LoginsDay   = new Graph(Graph::TYPE_DATE_BAR, $LoginsPerDay);
$H_LoginsDay->XLabel("Date");
$H_LoginsDay->YLabel("User Logins");
$H_LoginsDay->Scale(Graph::WEEKLY);
