<?PHP
#
#   FILE:  EditSearchConfigComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

# if we have a new synonym list
if (isset($_POST["F_SynonymList"]))
{
    # attempt to parse list
    $SynonymList = array();
    $Lines = explode("\n", $_POST["F_SynonymList"]);
    foreach ($Lines as $Line)
    {
        if (strchr($Line, "="))
        {
            list($Word, $SynonymText) = explode("=", $Line);
            $Word = trim($Word);
            if (!preg_match("/[^a-zA-Z0-9]+/", $Word))
            {
                $Synonyms = explode(",", $SynonymText);
                foreach ($Synonyms as $Synonym)
                {
                    $Synonym = trim($Synonym);
                    if (!preg_match("/[^a-zA-Z0-9]+/", $Synonym))
                    {
                        $SynonymList[$Word][] = $Synonym;
                    }
                }
            }
        }
    }

    # if we have synonym entries
    if (count($SynonymList))
    {
        # update synonym list in search engine
        $SearchEngine = new SPTSearchEngine();
        $SearchEngine->SetAllSynonyms($SynonymList);
    }
}


# go to main system administration page
$AF->SetJumpToPage("SysAdmin");

?>
