<?PHP
#
#   FILE:  ActivateAccount.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2006-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("New Account Activation");

# ----- CONFIGURATION  -------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)

# ----- MAIN -----------------------------------------------------------------

# ensure the $UserName variable is declared
$H_UserName = NULL;

# retrieve user name and confirmation code from URL or form
if (isset($_GET["UN"]) && strlen(trim($_GET["UN"])))
{
    $H_UserName = $_GET["UN"];
}
elseif (isset($_POST["F_UserName"])
        && strlen(trim($_POST["F_UserName"])))
{
    $H_UserName = $_POST["F_UserName"];
}
if (isset($_GET["AC"]) && strlen(trim($_GET["AC"])))
{
    $ActivationCode = $_GET["AC"];
}
elseif (isset($_POST["F_ActivationCode"])
        && strlen(trim($_POST["F_ActivationCode"])))
{
    $ActivationCode = $_POST["F_ActivationCode"];
}

# assume that all checks/actions will fail
$G_UserFound = FALSE;
$G_AccountActivated = FALSE;
$G_AccountAlreadyActivated = FALSE;
$G_EmailChanged = FALSE;
$H_NeedsPassword = FALSE;

# set up expectations for incoming form
$AdditionalErrorMessages = array(
        U_PASSWORDSDONTMATCH   => "The two passwords you entered did not match.",
        U_EMAILSDONTMATCH   => "The two e-mail addresses you entered did not match.",
        U_DUPLICATEUSERNAME => "The user name you entered is already in use.",
        U_ILLEGALUSERNAME   => "The user name you entered is not valid."
                ." User names must be made up of one word containing between 2 and 24"
                ." letters and/or numbers.",
        U_MAILINGERROR      => "An error was encountered trying to send an"
                ." e-mail message to activate your new account.  Please contact the"
                ." administrator of this site and inform them of the problem.",
        U_EMPTYPASSWORD => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_EMPTYPASSWORDAGAIN => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_ILLEGALPASSWORD => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_ILLEGALPASSWORDAGAIN => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_DUPLICATEEMAIL => "The e-mail address you entered is already associated"
                ." with an account.  If you have forgotten the account user name or"
                ." password you can click"
                ." <a href=\"index.php?P=ForgottenPasswordComplete&UN="
                        .(isset($_GET["F_EMail"]) ? $_GET["F_EMail"] : "")
                        ."\">here</a>"
                ." to send a reminder via e-mail.",
        U_ILLEGALEMAIL => "The e-mail address you entered is not valid",
        U_ILLEGALEMAILAGAIN => "The e-mail address you entered is not valid",
        );

$AdditionalErrorMessages =
    $AF->SignalEvent("EVENT_USER_SIGNUP_EXTEND_ERROR_LIST",
                     array($AdditionalErrorMessages));

$H_FTool = new FormTool("RequestAccount", array_shift($AdditionalErrorMessages));
$H_FTool->SetFieldValuesFromUrlParams();

# if user name and confirmation code found
if (isset($H_UserName) && isset($ActivationCode))
{
    # check user name
    $H_NewUser = new SPTUser($H_UserName);

    # if user name was valid
    if ($H_NewUser->Status() == U_OKAY)
    {
        # note that user was found
        $G_UserFound = TRUE;

        # if account is already activated
        if ($H_NewUser->IsActivated())
        {
            # note that account was already activated
            $G_AccountAlreadyActivated = TRUE;
            $OldEmail = $H_NewUser->Get("EMail");
            $NewEmail = $H_NewUser->Get("EMailNew");

            # Check if we're actually servicing a mail change request
            if ($H_NewUser->IsMailChangeCodeGood($ActivationCode) &&
                $OldEmail != $NewEmail )
            {
                $H_NewUser->Set("EMail", $NewEmail);
                $H_NewUser->Set("EMailNew", "");
                #Signal the email change
                $AF->SignalEvent("EVENT_USER_EMAIL_CHANGED", array(
                                     "UserId" => $H_NewUser->Id(),
                                     "OldEmail" => $OldEmail,
                                     "NewEmail" => $NewEmail));
                $G_EmailChanged = TRUE;
            }
        }
        else
        {
            # attempt to confirm code
            $G_AccountActivated = $H_NewUser->IsActivationCodeGood($ActivationCode);

            # if code was confirmed
            if ($G_AccountActivated)
            {
                # enable account for login
                $H_NewUser->RevokePriv(PRIV_USERDISABLED);
                $H_NewUser->IsActivated(TRUE);

                # signal that user has been activated
                $AF->SignalEvent("EVENT_USER_VERIFIED",
                        array("UserId" => $H_NewUser->Id()));

                $UserResource = $H_NewUser->GetResource();

                $H_NeedsPassword = $UserResource->Get("Has No Password");
            }
        }
    }
}
