<?PHP
#
#   FILE:  Mailman.php
#
#   NOTE: View the README file for more information.
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2014 Internet Scout Project
#   http://scout.wisc.edu/cwis/
#

class Mailman extends Plugin
{
    /**
    * Register information about this plugin.
    */
    public function Register()
    {
        $this->Name = "Mailman";
        $this->Version = "1.0.11";
        $this->Description = "Transition plugin from old Mailman to MLMailman.";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
            "CWISCore" => "2.2.3",
            "MetricsRecorder" => "1.2.4",
            "MailingList" => "1.0.0",
            "MLMailman" => "1.0.0",
            );
        $this->InitializeAfter = array("MailingList", "MLMailman");
        $this->EnabledByDefault = FALSE;
    }

    /**
    * Upgrade from a previous version.
    * @param string $PreviousVersion previous version
    * @return null|string NULL on success or error message on error
    */
    public function Upgrade($PreviousVersion)
    {
        $Database = new Database();

        # ugprade from versions < 1.0.3 to 1.0.3
        if (version_compare($PreviousVersion, "1.0.3", "<"))
        {

            # remove old lists table, if it's still around
            if (FALSE === $Database->Query("DROP TABLE IF EXISTS MailmanLists"))
                { return "Could not delete the mailing lists table."; }

            # remove old config table, if it's still around
            if (FALSE === $Database->Query("DROP TABLE IF EXISTS MailmanConfig"))
                { return "Could not delete the configuration table."; }

            # table for pending subscriptions
            if (FALSE === $Database->Query("
                CREATE TABLE IF NOT EXISTS Mailman_PendingSubscriptions (
                    UserId INT,
                    Created DATETIME,
                    PRIMARY KEY (UserId)
                );"))
                { return "Could not create the pending subscriptions table."; }
        }

        # upgrade from versions < 1.0.11 to 1.0.11
        if (version_compare($PreviousVersion, "1.0.11", "<"))
        {
            # this is a potentially interesting upgrade, as we've split
            # Mailman into MailingList and Mailman

            # transfer settings from this plugin that now beling in MailingList
            $MailingList = $GLOBALS["G_PluginManager"]->GetPlugin("MailingList");
            foreach (array("EnableMailingList", "MailingList", "MailingListLabel",
                           "SubscribeByDefault", "UnsubscribeWhenDeleted") as
                     $ToTransfer)
            {
                $MailingList->ConfigSetting($ToTransfer,
                                            $this->ConfigSetting($ToTransfer));
            }

            $MLMailman = $GLOBALS["G_PluginManager"]->GetPlugin("MLMailman");
            foreach (array("MailmanPrefix", "EnableUnsubscribeLink") as
                $ToTransfer)
            {
                $MLMailman->ConfigSetting($ToTransfer,
                    $this->ConfigSetting($ToTransfer));

            }

            if (FALSE === $Database->Query(
                    "DROP TABLE IF EXISTS Mailman_PendingSubscriptions"))
                { return "Could not delete the pending subscriptions table"; }
        }

        return NULL;
    }
}
