<?PHP
#
#   FILE:  Autofix.php
#
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Automatically fixing URL...");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$ResourceId = isset($_GET["ResourceId"]) ? intval($_GET["ResourceId"]) : NULL;
$FieldId = isset($_GET["FieldId"]) ? intval($_GET["FieldId"]) : NULL;
$Resource = new Resource($ResourceId);
$Field = new MetadataField($FieldId);

if ($Resource->Status() == 1 && $Field->Status() == MetadataSchema::MDFSTAT_OK)
{
    $Url = $AF->SignalEvent("URLCHECKER_GET_INVALID_URL", array($Resource, $Field));

    if (!is_null($Url) && strlen($Url->FinalUrl))
    {
        $Resource->Set($Field, $Url->FinalUrl);

        if ($Resource->SchemaId() == MetadataSchema::SCHEMAID_DEFAULT)
        {
            $Resource->Set("Date Last Modified", "now");
            $Resource->Set("Last Modified By Id", $GLOBALS["G_User"]);
        }
    }
}

$AF->SuppressHTMLOutput();
$AF->SetJumpToPage("index.php?P=P_UrlChecker_Results");
