<?PHP
#
#   FILE:  RequestAccount.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Output the HTML option list for states.
* @param string $ResultVar HTML form element name.
*/
function PrintStatesOptionList($ResultVar)
{
    global $FTool;

    $States = FormTool::GetArrayOfUsStates();
    $SelectedValue = $FTool->ValueForField($ResultVar);

    PrintOptionList($ResultVar, $States, $SelectedValue);
}

/**
* Output HTML for a form field.
* @param string $Name Form element name to output.
*/
function PrintFormFieldValue($Name)
{
    global $FTool;

    print defaulthtmlentities($FTool->ValueForField($Name));
}

# ----- MAIN -----------------------------------------------------------------

global $FTool;

PageTitle("New User Sign-Up");

# set up expectations for incoming form
$AdditionalErrorMessages =
    UserEditingUI::GetAdditionalErrorCodes(
        isset($_GET["F_EMail"]) ? $_GET["F_Email"] : "" );

$AdditionalErrorMessages =
    $AF->SignalEvent("EVENT_USER_SIGNUP_EXTEND_ERROR_LIST",
                     array($AdditionalErrorMessages));

$FTool = new FormTool("RequestAccount", array_shift($AdditionalErrorMessages));
$FTool->SetFieldValuesFromUrlParams();
