<?PHP
#
#   FILE:  PluginConfig.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2014 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# check that the user has sufficient privileges
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

$PluginName = isset($_GET["PN"]) ? $_GET["PN"] : NULL;
$H_Plugin = $G_PluginManager->GetPlugin($PluginName, TRUE);
$Attribs = $H_Plugin->GetAttributes();
$CfgValues = array();
foreach ($Attribs["CfgSetup"] as $Name => $Params)
{
    $CfgValues[$Name] = $H_Plugin->ConfigSetting($Name);
}
$H_CfgUI = new ConfigSettingsUI($Attribs["CfgSetup"], $CfgValues);

if ($H_Plugin && isset($_POST["Submit"]))
{
    if ($_POST["Submit"] == "Save Changes")
    {
        # retrieve form values
        $H_CfgUI->SetEventToSignalOnChange("EVENT_PLUGIN_CONFIG_CHANGE",
                array("PluginName" => $Attribs["Name"],
                        "SettingName" => NULL,
                        "OldValue" => NULL,
                        "NewValue" => NULL));
        $NewValues = $H_CfgUI->GetNewSettingsFromForm();

        # save new values
        foreach ($NewValues as $Name => $NewValue)
        {
            $H_Plugin->ConfigSetting($Name, $NewValue);
        }
    }

    $AF->SetJumpToPage("Plugins");
}

