<?PHP

#
#   FILE:  SPT--StandardHtmlLoad.php
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# neuter for any pages that still include this file
return;

require_once(dirname(__FILE__)."/SPT--Common.php");

# if output buffering is on
if (ob_get_level())
{
    # save any buffered output
    $BufferedDebugOutput = trim(ob_get_contents());

    # clear output buffer and turn off buffering
    ob_end_clean();
}

# save time stamp for page load time calculations
$SavePageGenerationBeginTime = isset($PageGenerationBeginTime) ? $PageGenerationBeginTime : getmicrotime();

# buffer output from HTML file
ob_start();

# load header, set character coding
header("Content-type: text/html; charset=".$SysConfig->DefaultCharacterSet(),
        true);

# load HTML file
include(CorrespondingHtmlFile());

# save buffered output
$BufferedPageOutput = ob_get_contents();

# clear output buffer and turn off buffering
ob_end_clean();

# write out standard page start
include(FindUIFile("include/SPT--StandardPageStart.html"));

# restore time stamp for page load time calculations
# (value is reset by standard page start)
$PageGenerationBeginTime = $SavePageGenerationBeginTime;

# write out buffered output
print($BufferedPageOutput);

# if we have buffered debugging output
if (isset($BufferedDebugOutput) && strlen($BufferedDebugOutput))
{
    # write out standard page end with </body> and </html> tags trimmed off
    ob_start();
    include(FindUIFile("include/SPT--StandardPageEnd.html"));
    $BufferedPageOutput = ob_get_contents();
    ob_end_clean();
    $BufferedPageOutput = preg_replace("%</html>$%i", "", rtrim($BufferedPageOutput));
    $BufferedPageOutput = preg_replace("%</body>$%i", "", rtrim($BufferedPageOutput));
    print($BufferedPageOutput);

    # write out any buffered debugging output followed by </body></html>
    ?><div style="clear: both;">
    <br /><br /><br />
    <table width="100%" cellpadding="10" 
            style="border: 3px solid #999999;  color: #000000;  background: #FFFFFF;">
    <tr><td align="left">
    <?PHP  print($BufferedDebugOutput);  ?>
    </td></tr></table>
    </div></body></html><?PHP
}
else
{
    # write out standard page end
    include(FindUIFile("include/SPT--StandardPageEnd.html"));
}

?>
