<?PHP
#
#   FILE:  AddClassification.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* print ID of classification under which to add new classification
*/
function PrintParentId()
{
    global $ParentClass;
    print($ParentClass->Id());
}

/**
* print string with hierarchy above new classification
*/
function PrintLocation()
{
    global $ParentId;
    global $ParentClass;

    if ($ParentId == -1)
    {
        print("(top)");
    }
    else
    {
        print $ParentClass->FullName();
    }
}

/**
* print the FieldId
*/
function PrintFieldId()
{
    global $FieldId;

    print $FieldId;
}

/**
* print the ClassTypeName
*/
function PrintFieldName()
{
    global $FieldId;

    $Schema = new MetadataSchema;

    $Field = $Schema->GetField($FieldId);

    print $Field->GetDisplayName();
}

/**
* function to determine if field has itemlevelqualifiers
*/
function UsesQualifiers()
{
    global $FieldId;

    $Schema = new MetadataSchema();
    $Field = $Schema->GetField($FieldId);

    if (is_object($Field)) {
        return $Field->UsesQualifiers(); }
    else {
        return FALSE; }
}

/**
* print Qualifier option list
*/
function PrintQualifierList()
{
    global $FieldId;

    $Schema = new MetadataSchema();
    $Field = $Schema->GetField($FieldId);

    if ($Field->HasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        PrintOptionList("F_QualifierId", $Items, $Field->DefaultQualifier(),
            0, 1, NULL, FALSE);
    }
    else if ($Field->DefaultQualifier() > 0)
    {
        $Qualifier = new Qualifier($Field->DefaultQualifier());
        if (is_object($Qualifier)) {
            print $Qualifier->Name(); }
    }
    else {
        print "None"; }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ParentClass;
global $ParentId;
global $FieldId;

if (!CheckAuthorization(PRIV_CLASSADMIN)) {  return;  }

# look up parent class info (make sure they get initialized)
$ParentId = (isset($_GET["ParentId"])) ? $_GET["ParentId"] : FALSE ;
$FieldId = (isset($_GET["FieldId"])) ? $_GET["FieldId"] : FALSE ;
$ParentClass = new Classification($ParentId);

# register post-processing function with the application framework
$AF->AddPostProcessingCall("PostProcessingFn");

/**
* post-processing call
*/
function PostProcessingFn()
{
    # global variables
    global $Session;

    $Session->UnregisterVariable("ErrorMessages");
}
