<?PHP
#
#   FILE:  DownloadFile.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

$Id = GetArrayValue($_GET, "ID", GetArrayValue($_GET, "Id"));

# if file ID was supplied
if (!is_null($Id))
{
    $FileId = intval($Id);
    $File = new File($FileId);

    # if file info was loaded successfully
    if ($File->Status() == File::FILESTAT_OK)
    {
        $Field = new MetadataField($File->FieldId());
        $Resource = new Resource($File->ResourceId());

        # if user can view file
        if ($Resource->UserCanViewField($User, $Field))
        {
            $GLOBALS["AF"]->DownloadFile($File->GetNameOfStoredFile(),
                    $File->Name(), $File->GetMimeType());
        }
        else
        {
            CheckAuthorization(-1);
        }
    }
}

# if a file was not found, the HTML template will be loaded instead
