<?PHP
#
#   FILE:  EditSysConfig.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintCheckedWhen($Option, $Value)
{
    global $G_SysConfig;
    if ($G_SysConfig->{$Option}() == $Value){ print("checked"); }
}

function PrintCheckedIf($Option)
{
    global $G_SysConfig;
    if ($G_SysConfig->{$Option}()) {  print("checked");  }
}
function PrintCheckedIfNot($Option)
{
    global $G_SysConfig;
    if (!$G_SysConfig->{$Option}()) {  print("checked");  }
}

function PrintCharacterSetOptionList()
{
    global $G_SysConfig;

    # create options for character coding
    $CharSets = array(
            "ISO-8859-1" => "ISO-8859-1",
            "UTF-8" => "UTF-8");

    # create option list
    $OptionList = new HtmlOptionList("F_DefaultCharacterSet", $CharSets,
            $G_SysConfig->DefaultCharacterSet());

    # print option list
    $OptionList->PrintHtml();
}

function PrintLoggingLevelOptionlist()
{
    $LoggingLevels = array(
        ApplicationFramework::LOGLVL_FATAL => "1 - Fatal",
        ApplicationFramework::LOGLVL_ERROR => "2 - Error",
        ApplicationFramework::LOGLVL_WARNING => "3 - Warning",
        ApplicationFramework::LOGLVL_INFO => "4 - Info",
        ApplicationFramework::LOGLVL_DEBUG => "5 - Debug",
        ApplicationFramework::LOGLVL_TRACE => "6 - Trace");

    $OptionList = new HtmlOptionList("F_LoggingLevel", $LoggingLevels,
            $GLOBALS["AF"]->LoggingLevel());

    $OptionList->PrintHtml();
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PrintValue($ValueName)
{
    global $G_SysConfig;

    $FormVar = "F_".$ValueName;
    if (isset($_SESSION[$FormVar])) ${$FormVar} = $_SESSION[$FormVar];
    if (isset(${$FormVar}))
    {
        print(htmlspecialchars(StripXSSThreats(${$FormVar})));
        unset($_SESSION[$FormVar]);
    }
    else
    {
        print(htmlspecialchars(StripXSSThreats($G_SysConfig->{$ValueName}())));
    }
}

# ----- MAIN -----------------------------------------------------------------

require_once "lib/AxisPHP/Axis--StandardLibrary.php";

if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }
