<?PHP
#
#   FILE:  RebuildSearch.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

if ($_GET["AC"] == "Background")
{
    # set relatively high PHP timeout in case of large collection
    set_time_limit(600);

    # retrieve schemas to rebuild across
    $Schemas = MetadataSchema::GetAllSchemas();

    # initialize count of items queued to be displayed
    $H_ResourcesQueued = 0;

    # for each schema
    $SearchEngine = new SPTSearchEngine();
    foreach ($Schemas as $SchemaId => $Schema)
    {
        # for each resource in schema
        $RFactory = new ResourceFactory($SchemaId);
        $Ids = $RFactory->GetItemIds();
        foreach ($Ids as $Id)
        {
            # queue update for resource
            $SearchEngine->QueueUpdateForItem($Id,
                    ApplicationFramework::PRIORITY_BACKGROUND);
        }

        # add queued resources to count of total
        $H_ResourcesQueued += count($Ids);
    }
}

