<?PHP
#
#   FILE:  F-Blog_PrintBlogEntry.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
 * Print the summary of a blog
 * @param $Entry the blog entry to print
 */
function Blog_PrintBlogEntry(Blog_Entry $Entry)
{
    # set current blog
    $BlogPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("Blog");

    $Title = $Entry->Title();
    $Body = $Entry->Body();
    $StartDate = date("M j, Y", strtotime($Entry->PublicationDate()));
    $Id = defaulthtmlentities($Entry->Id());
    $Image = $Entry->Image();
    $ImageUrl;
    if (!is_null($Image) && $Image instanceof SPTImage)
    {
        $ImageURL = $Image->PreviewUrl();
        $ImageAltText = $Image->AltText();
    }

    $UserCanEditEntry = $Entry->UserCanEdit( $GLOBALS["G_User"] );
    // @codingStandardsIgnoreStart
    ?>
        <tr>
            <td class="BlogEntrySummary">
                <a class="BlogEntryTitle" href="<?PHP print($Entry->EntryUrl()); ?>"><b><?PHP print($Title); ?></b></a>
                <?PHP if ($UserCanEditEntry) { ?>
                    <a class="Button ac-homepage-action-button" href="index.php?P=EditResource&amp;ID=<?PHP print $Id; ?>">Edit</a>
                <?PHP } ?>
                <br>
                <i><?PHP print($StartDate); ?></i><br>
                <?PHP if (isset($ImageURL)) { ?>
                    <img src="<?PHP print($ImageURL); ?>" alt="<?PHP
                            print htmlspecialchars($ImageAltText);  ?>" />
                <?PHP } ?>
                <?PHP print($Body); ?>
                <?PHP $BlogPlugin->PrintShareButtonsForEntry($Entry, 16, "grey"); ?>
            </td>
        </tr>
    <?PHP
    // @codingStandardsIgnoreEnd
}

?>
