<?PHP
#
#   FILE:  ConfirmNotifySubscribers.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Notify Blog Subscribers Confirmation");

# get the blog plugin and entry
$H_Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
$H_Entry = new Blog_Entry(GetArrayValue($_GET, "ID"));

# don't allow unauthorized access
if (!$H_Entry->UserCanEdit($GLOBALS["G_User"]))
{
    CheckAuthorization(FALSE);
    return;
}

# don't allow notification if the entry is not from the "email blog"
if ($H_Entry->GetBlogId() != $H_Blog->ConfigSetting("EmailNotificationBlog"))
{
    $GLOBALS["AF"]->SetJumpToPage(
        "index.php?P=P_Blog_Entry&EntryId=" . $H_Entry->Id()
        . "&Error=ERROR_NOT_EMAIL_BLOG");
    return;
}
