<?PHP
#
#   FILE:  SubscriberStatistics.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }

PageTitle("Blog Subscription Information");

$MyPlugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

# set up pagination
$ItemsPerPage = 30;

$H_TransportControlsUI = new TransportControlsUI(
    TransportControlsUI::NO_ITEM_TYPE, $ItemsPerPage);

# pull out our current list of subscribers
$H_Subscribers = $MyPlugin->GetSubscribers();

# tell the TransportControls how many there were
$H_TransportControlsUI->ItemCount(count($H_Subscribers));

# subset our list to only be the selected ones
$H_Subscribers = array_slice(
    $H_Subscribers,
    $H_TransportControlsUI->StartingIndex(),
    $ItemsPerPage);

# if we have subscriber metrics, make a plot of them
if ( $GLOBALS["G_PluginManager"]->PluginEnabled("MetricsRecorder") )
{
    # pull our data out of metrics recorder
    $Recorder = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsRecorder");
    $Data = $Recorder->GetEventData("Blog", "NumberOfSubscribers",
                                    date("Y-m-d", strtotime('-24 months')) );

    # convert into the format that Graph wants
    $GraphData = array();
    foreach ($Data as $Item)
    {
        if ($Item["DataTwo"] > 0)
        {
            $GraphData[strtotime($Item["EventDate"])] = array(
                $Item["DataTwo"] );
        }
    }

    # generate and label our graph
    $H_Graph = new Graph(Graph::TYPE_DATE, $GraphData);
    $H_Graph->Title("");
    $H_Graph->XLabel("Date");
    $H_Graph->YLabel("Subscribers");
}
