<?PHP
#
#   FILE:  UrlChecker_ConstraintList.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2002-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Encapsulates a list of constraints.
*/
class UrlChecker_ConstraintList implements IteratorAggregate
{

    /**
    * Add a constraint to the list.
    * @param UrlChecker_Constraint $Constraint Constraint to add.
    */
    public function AddConstraint(UrlChecker_Constraint $Constraint)
    {
        $this->List[] = $Constraint;
    }

    /**
    * Get the number of constraints currently in the list.
    * @return Returns the number of constraints currently in the list.
    */
    public function GetConstraintCount()
    {
        return count($this->List);
    }

    /**
    * Get an iterator object to allow iterating over the constraints.
    * @return Returns an ArrayIterator object to allow iterating over the
    *      constraints.
    */
    public function getIterator()
    {
        return new ArrayIterator($this->List);
    }

    private $List;

}
