<?PHP

class UrlChecker_InvalidUrl
{
    /**
    * Constructor: set data members from the given array.
    * @param array $Data Name/value array
    */
    public function __construct(array $Data)
    {
        foreach ($Data as $Key => $Value)
        {
            # some basic validation
            if (isset($this->$Key) && $Key != "Url" )
            {
                $this->$Key = $Value;
            }
        }

        $ThisResource = $this->GetAssociatedResource();
        $this->SchemaId = $ThisResource->SchemaId();

        $BadField = $this->GetAssociatedField();
        if (!is_null($BadField))
        {
            $this->Url = $ThisResource->Get( $BadField );
        }
    }

    /**
    * Return a resource with the ID specified by the invalid URL.
    * @return a resource
    */
    public function GetAssociatedResource()
    {
        $Resource = new Resource($this->ResourceId);
        return ($Resource->Status() == 1) ? $Resource : NULL;
    }

    /**
    * Return a metadata field with the ID specified by the invalid URL.
    * @return a metadata field
    */
    public function GetAssociatedField()
    {
        $Schema = new MetadataSchema($this->SchemaId);
        $Field = $Schema->GetField($this->FieldId);
        return ($Field !== NULL &&
                $Field->Status() == MetadataSchema::MDFSTAT_OK) ?
                        $Field : NULL;
    }

    public $ResourceId = -1;
    public $FieldId = -1;
    public $Hidden = 0;
    public $CheckDate = "";
    public $TimesInvalid = 0;
    public $Url = "";
    public $StatusCode = -1;
    public $ReasonPhrase = "";
    public $IsFinalUrlInvalid = 0;
    public $FinalUrl = "";
    public $FinalStatusCode = -1;
    public $FinalReasonPhrase = "";
    public $Time = 0;

    private $SchemaId = NULL;
}
