<?PHP

require_once("include/StartUp.php");

$DB = new Database();
# see if there are preexisting users

# get the list of users who lack an entry in the Resources table.
$DB->Query(
    "SELECT UserId FROM APUsers WHERE "
    ."UserId NOT IN (SELECT UserId".MetadataSchema::SCHEMAID_USER
    ." FROM Resources WHERE SchemaId = ".MetadataSchema::SCHEMAID_USER.")");
$UserIds = $DB->FetchColumn("UserId");

# grab the User schema
$Schema = new MetadataSchema(MetadataSchema::SCHEMAID_USER);
$Fields = $Schema->GetFields();
$Map = array();

# map field names (APUsers columns) to resource table column names
foreach ($Schema->GetFields() as $Field)
{
    $Map[$Field->Name()] = $Field->DBFieldName();
}

# construct the strings describing sql field names in the Resources and User tables
$APUsers = implode(",", array_keys($Map));
$Resources = implode(",", array_values($Map));

# set the resource ID column to auto increment temporarily
$DB->Query(
        "ALTER TABLE Resources MODIFY COLUMN ResourceId INT AUTO_INCREMENT");

# migrate all of the data over
$DB->Query(
        "INSERT INTO Resources "
        ."(ResourceId, SchemaId, ".$Resources.") "
        ."SELECT NULL, ".intval(MetadataSchema::SCHEMAID_USER).", ".$APUsers."
        FROM APUsers WHERE UserId IN (".implode(",",$UserIds).")");

# remove the auto increment
$DB->Query(
        "ALTER TABLE Resources MODIFY COLUMN ResourceId INT NOT NULL");
