<?PHP
#
#   FILE:  index.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/cwis
#

# make sure that output buffering is initially turned off
if (ob_get_level()) {  ob_end_clean();  }

# if it appears that the software has not yet been installed
if (((!file_exists("local/config.php") && !file_exists("config.php"))
     || file_exists("NEWVERSION"))
    && file_exists("installcwis.php"))
{
    # jump to installation
    ?><html>
    <head><meta http-equiv="refresh" content="0; URL=installcwis.php"></head>
    <body bgcolor="white"></body>
    </html><?PHP
    exit();
}

# if on plugin configuration page
$PluginCfgPages = array(
        "Plugins",
        "PluginConfig",
        );
if (array_key_exists("P", $_GET) && in_array($_GET["P"], $PluginCfgPages))
{
    # ensure that plugin configurations are all loaded
    $GLOBALS["StartUpOpt_FORCE_PLUGIN_CONFIG_LOAD"] = TRUE;
}

# set up operating environment
require_once("include/StartUp.php");

# set UI for logged-in user (or default UI if not logged in)
$AF->ActiveUserInterface(GetActiveUI());

# use the home page as the default page to load
$Page = "Home";

# if the page was specified as part of the URL
if (isset($_GET["P"]))
{
    $Page = $_GET["P"];
}
# else if the URL was rewritten
else if (ApplicationFramework::WasUrlRewritten())
{
    # default to 404 error page (this may be overriden by clean URLs)
    $Page = "404";
}

# display errors if logged in with admin privileges
if ($G_User->HasPriv(PRIV_SYSADMIN))
{
    ini_set("display_errors", 1);
}

# tell application framework to load the page
$AF->LoadPage($Page);
