<?PHP
/**
* Print the blank text field quick search field for the QuickSearch
* JS object
* @param int $FieldId The FieldId for the form element to assign
* @param int $CurrentValue The option's Id value, not for user display
* @param string $CurrentDisplayValue The value to initially populate the field with
* @param boolean $CloneAfter Whether to place a clone after this field
*/
function PrintQuickSearchField(
    $FieldId, $CurrentValue, $CurrentDisplayValue, $CloneAfter=FALSE)
{
    $GLOBALS["AF"]->RequireUIFile("jquery-ui.js");
    $GLOBALS["AF"]->RequireUIFile("CW-QuickSearch.js");

    $Field = new MetadataField($FieldId);
    $SafeDBFieldName = defaulthtmlentities($Field->DBFieldName());

    $SafeFieldId = defaulthtmlentities($FieldId);
    $SafeCurrentValue = defaulthtmlentities($CurrentValue);
    $SafeCurrentDisplayValue = defaulthtmlentities($CurrentDisplayValue);
    // @codingStandardsIgnoreStart
?>
   <div class="cw-quicksearch cw-quicksearch-fieldid-<?PHP print $FieldId; ?>"
        data-fieldid="<?PHP print $SafeFieldId; ?>">
        <textarea class="cw-quicksearch-display cw-resourceeditor-metadatafield F_<?PHP print $SafeDBFieldName; ?> cw-autoresize"><?PHP print $SafeCurrentDisplayValue ?></textarea>

        <input name="F_<?PHP print $SafeDBFieldName; ?>[]"
            class="cw-quicksearch-value" type="hidden"
            value="<?PHP print $SafeCurrentValue ?>" />
        <div style="display: none;"
             class='cw-quicksearch-menu'>
            <div class='cw-quicksearch-message ui-front'></div>
        </div>
    </div>
    <?PHP if ($CloneAfter) {?>
    <div class="cw-quicksearch-template cw-quicksearch cw-quicksearch-fieldid-<?PHP print $FieldId; ?>"
         style="display: none;"
         data-fieldid="<?PHP print $SafeFieldId; ?>">
      <textarea class="cw-quicksearch-display cw-resourceeditor-metadatafield F_<?PHP print $SafeDBFieldName; ?> cw-autoresize"></textarea>

      <input name="F_<?PHP print $SafeDBFieldName; ?>[]"
          class="cw-quicksearch-value" type="hidden"
          value="<?PHP print $SafeCurrentValue ?>" />
      <div style="display: none;"
           class='cw-quicksearch-menu'>
          <div class='cw-quicksearch-message ui-front'></div>
      </div>
    </div>
<?PHP
    }
    // @codingStandardsIgnoreEnd
}
