(function(document, $){
  var RouterUrl = cw.getRouterUrl(),
      ApiUrl = RouterUrl+"?P=MetadataFieldOrderingComplete&SendResponse=0";

  function itemMoved(e, ui) {
    var $sibling, $parent;
    var $item = $(ui.item);

    if ($item.prev().length) {
      $sibling = $item.prev();

      moveItemAfter(
        $item.data("orderid"),
        $item.data("itemid"),
        $item.data("itemtype"),
        $sibling.data("itemid"),
        $sibling.data("itemtype"));
    } else if ($item.parents(".cw-fieldordering-group").length) {
      $parent = $item.parents(".cw-fieldordering-group");

      moveFieldToTopOfGroup(
        $item.data("orderid"),
        $parent.data("itemid"),
        $item.data("itemid"));
    } else {
      moveItemToTop(
        $item.data("orderid"),
        $item.data("itemid"),
        $item.data("itemtype"));
    }
  }

  function moveItemAfter(orderId, itemId, itemType, targetId, targetType) {
    $.post(ApiUrl, {
      "F_Submit": "MoveAfter",
      "F_OrderId": orderId,
      "F_ItemId": itemId,
      "F_ItemType": itemType,
      "F_TargetId": targetId,
      "F_TargetType": targetType
    });
  }

  function moveItemToTop(orderId, itemId, itemType) {
    $.post(ApiUrl, {
      "F_Submit": "MoveItemToTop",
      "F_OrderId": orderId,
      "F_ItemId": itemId,
      "F_ItemType": itemType
    });
  }

  function moveFieldToTopOfGroup(orderId, groupId, fieldId) {
    $.post(ApiUrl, {
      "F_Submit": "MoveFieldToTopOfGroup",
      "F_OrderId": orderId,
      "F_GroupId": groupId,
      "F_FieldId": fieldId
    });
  }

  function positionChanged(e, ui) {
    // move the helper to match the hierarchy into which it's placed
    if ($(".cw-fieldordering-group .ui-sortable-placeholder").length) {
      $(".ui-sortable-helper").stop(true).animate({"padding-left": "25px"}, 300);
    } else {
      $(".ui-sortable-helper").stop(true).animate({"padding-left": "0"}, 300);
    }

    $(".cw-fieldordering-group ul:has(.cw-fieldordering-noitems)").each(function(){
      var $this = $(this);

      if ($this.children().length > 1) {
        $(".cw-fieldordering-noitems", $this).remove();
      }
    });

    $(".cw-fieldordering-group ul").each(function(){
      var $this = $(this);

      if (!$this.has(".cw-fieldordering-noitems").length && $this.children(":not(.cw-fieldordering-noitems,.ui-sortable-helper)").length === 0) {
        $this.prepend('<li class="cw-fieldordering-noitems cw-fieldordering-field">There are no items in this group.</li>');
      }
    });
  }

  function sorting(e, ui) {

  }

  $(document).ready(function(){
    var $groupHeaders = $(".cw-fieldordering-group b");

    // remove unnecessary buttons
    $(".cw-fieldordering-jshide").remove();

    // use a better cursor
    $(".cw-fieldordering-field:not(.cw-fieldordering-noitems)").css("cursor", "move");
    $(".cw-fieldordering-group b").css("cursor", "move");

    // make items sortable
    $(".cw-fieldordering-list").sortable({
      "axis": "y",
      "cancel": "input,button,.cw-fieldordering-noitems,.cw-button",
      "change": positionChanged,
      "containment": "document",
      "items": ".cw-fieldordering-field, .cw-fieldordering-group",
      "update": itemMoved,
      "sort": sorting
    });

    // disable text selection
    $(".cw-fieldordering-list").disableSelection();

    // disable group sorting when moving a group
    $groupHeaders.mousedown(function(){
      $(".cw-fieldordering-list").sortable(
        "option",
        "items",
        "> .cw-fieldordering-field, .cw-fieldordering-group");
    });

    // re-enable group sorting when done moving a group
    $groupHeaders.mouseup(function(){
      $(".cw-fieldordering-list").sortable(
        "option",
        "items",
        ".cw-fieldordering-field, .cw-fieldordering-group");
    });
  });

})(document, jQuery);
