<?PHP
#
#   FILE:  PrivilegeSet.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2014 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Compatibility layer allowing interfaces built against the privilege
* system from CWIS 3.0.0 through 3.1.0 to continue working.  This
* should not be used in new code.
*/
class PrivilegeSetCompatibilityShim {

    function __construct(CWUser $User)
    {
        $this->User = $User;
    }

    function IsGreaterThan(PrivilegeSet $Set, $Resource = PrivilegeSet::NO_RESOURCE)
    {
        return $Set->MeetsRequirements($this->User, $Resource);
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------

    private $User;
}
