<?PHP
#
#   FILE:  CleanSpamComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Removal all messages by a specified user, remove their post privs,
* and disable their account.
* @param Integer $PosterId UserId of the target user
*/
function SlayUser($PosterId)
{
    global $G_User;

    # Refuse to slay oneself:
    if ($G_User->Id() == $PosterId) {
        return; }

    $Poster = new CWUser($PosterId);
    if ($Poster->Status() == U_OKAY )
    {
        $Poster->RevokePriv(PRIV_POSTTOFORUMS);
        $Poster->RevokePriv(PRIV_POSTCOMMENTS);
        $Poster->GrantPriv(PRIV_USERDISABLED);

        $DB = new Database();
        $DB->Query("DELETE FROM Messages WHERE "
                   ."PosterId = ".$PosterId);
    }
    else
    {
        print("<pre>");
        print("Failed to revoke posting privs, error follows:\n");
        print($Poster->StatusMessage( $Poster->Status()));
        print("</pre>");
        exit(1);
    }
}

# Remove a user's posting privilege
/**
* Remove posting privs from a specified user.
* @param Integer $PosterId UserId of the target user
*/
function RemovePostPrivilege($PosterId)
{
    global $G_User;

    if ($G_User->Id() == $PosterId ) {
        return; }

    $Poster = new CWUser($PosterId);
    if ($Poster->Status() == U_OKAY) {
        $Poster->RevokePriv(PRIV_POSTTOFORUMS); }
}

# ----- MAIN -----------------------------------------------------------------

global $AF;

# Check that the user has the required Privs.
if (!CheckAuthorization(PRIV_FORUMADMIN, PRIV_USERADMIN)) {
    return; }

# Bounce them to UnauthorizedAccess if the required POST values weren't present.
if (!isset($_POST["F_Submit"]) || !isset($_POST["F_PosterId"]) ||
    !(isset($_POST["F_ResourceId"]) || isset($_POST["F_TopicId"])))
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

# Otherwise, extract the expectecd variables:
$F_Submit = $_POST["F_Submit"];
$F_PosterId = intval($_POST["F_PosterId"]);

if (isset($_POST["F_ResourceId"])) {
    $F_ResourceId = intval($_POST["F_ResourceId"]); }
else {
    $F_TopicId = intval$($_POST["F_TopicId"]); }

# Take action based on the button that was clicked:
if ($F_Submit == "Clean Spam") {
    SlayUser( $F_PosterId ); }
else if ($F_Submit == "Remove Post Privilege") {
    RemovePostPrivilege( $F_PosterId ); }

# And then redirect back to the Resource or Forum as appropriate:
if (isset($F_ResourceId))
{
    if ($F_ResourceId == -1 ) {
        $AF->SetJumpToPage("TrackUserComments"); }
    else {
        $AF->SetJumpToPage("index.php?P=FullRecord&ID=".$F_ResourceId); }
}
else
{
    $AF->SetJumpToPage("index.php?P=TopicMessages&TI=".$F_TopicId );
}
